package cn.com.duiba.activity.center.api.enums.tlcb;

import org.apache.commons.lang.StringUtils;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/6/14 上午11:15
 */
public enum TaskStatusEnum {
    LOCK(-1,"lock","未解锁"),
    CREATE(0,"create","未完成"),
    WAIT_RECEIVE(1,"waitReceive","待领取"),
    RECEIVED(2,"received","已领取"),
    SUCCESS(3,"success","领取成功"),
    FAIL(4,"fail","领取失败"),

    ;
    private Integer status;
    private String code;
    private String desc;

    TaskStatusEnum(Integer status, String code, String desc) {
        this.status = status;
        this.code = code;
        this.desc = desc;
    }

    public static TaskStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        TaskStatusEnum[] values = TaskStatusEnum.values();
        for (TaskStatusEnum value : values) {
            if (value.getStatus().equals(status)) {
                return value;
            }
        }
        return null;
    }

    public static TaskStatusEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        TaskStatusEnum[] values = TaskStatusEnum.values();
        for (TaskStatusEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return status;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
