package cn.com.duiba.activity.center.api.remoteservice.shop.guide;

import cn.com.duiba.activity.center.api.dto.shop.guide.ShopGuideDto;
import cn.com.duiba.activity.center.api.params.ShopGuideListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hong
 * time 2022/10/9.
 */
@AdvancedFeignClient
public interface RemoteShopGuideService {

    List<ShopGuideDto> selectList(ShopGuideListParam param);

    Integer selectCount(ShopGuideListParam param);

    ShopGuideDto selectById(Long id);

    Long insert(ShopGuideDto dto);

    Boolean update(ShopGuideDto dto) throws BizException;

    Page<ShopGuideDto> selectPage(ShopGuideListParam param);

    /**
     * 移动
     * @param type 1上移  2下移
     *
     * @return
     */
    Boolean move(Long id, Integer type);
}
