package cn.com.duiba.activity.center.api.dto.underseagame;

import java.io.Serializable;
import java.util.Date;

/**
 * 海底游戏机游戏开始记录
 * @Author: xuwei
 * @Date: 2020/07/16
 */
public class UnderseaGameStartRecordDto implements Serializable {

    private static final long serialVersionUID = 8164386937123547198L;

    /**
     * 游戏状态-初始化
     */
    public static final int STATUS_INIT = 0;
    /**
     * 游戏状态-进行中
     */
    public static final int STATUS_RUNNING = 1;
    /**
     * 游戏状态-已结束
     */
    public static final int SATAUS_FINISHED = 2;
    /**
     * 游戏状态-扣积分失败
     */
    public static final int STATUS_CREDITS_FAILED = 3;

    /**
     * 主键
     */
    private Long id;

    /**
     * 海底游戏机配置ID
     */
    private Long configId;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 扣积分子订单编号
     */
    private String orderNum;

    /**
     * 当前关卡（1, 2, 3)
     */
    private Integer curRoundIndex;

    /**
     * 复活次数
     */
    private Integer reviveTimes;

    /**
     * 游戏总分
     */
    private Integer totalScore;

    /**
     * 游戏状态。 0:初始化 1:进行中 2:已结束 3:扣积分失败
     */
    private Integer gameStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConfigId() {
        return configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum == null ? null : orderNum.trim();
    }

    public Integer getCurRoundIndex() {
        return curRoundIndex;
    }

    public void setCurRoundIndex(Integer curRoundIndex) {
        this.curRoundIndex = curRoundIndex;
    }

    public Integer getReviveTimes() {
        return reviveTimes;
    }

    public void setReviveTimes(Integer reviveTimes) {
        this.reviveTimes = reviveTimes;
    }

    public Integer getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public Integer getGameStatus() {
        return gameStatus;
    }

    public void setGameStatus(Integer gameStatus) {
        this.gameStatus = gameStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}