package cn.com.duiba.activity.center.api.remoteservice.underseagame;

import cn.com.duiba.activity.center.api.dto.underseagame.UnderseaGameConfigDto;
import cn.com.duiba.activity.center.api.dto.underseagame.UnderseaGamePrizeConfigDto;
import cn.com.duiba.api.bo.activity.SyncMsgData;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 海底游戏机配置-远程服务接口
 * @Author: xuwei
 * @Date: 2020/07/16
 */
@AdvancedFeignClient
public interface RemoteUnderseaGameConfigService {

    UnderseaGameConfigDto find(Long id, boolean withInterfaceJson);

    UnderseaGameConfigDto findWithPrizes(Long id, boolean withInterfaceJson);

    Long insert(UnderseaGameConfigDto record);

    void update(UnderseaGameConfigDto record);

    void updateOpId(Long id, Long opId);

    void publish(Long id);

    void delete(Long id);

    List<UnderseaGamePrizeConfigDto> findPrizesByConfigId(Long configId, Boolean deleted);

    boolean decrPrizeStock(Long prizeId);

    void rollbackPrizeStock(Long prizeId);

    /**
     * 同步商家编码
     * @param syncMsgData 同步数据
     * @return 影响行数
     */
    Integer syncMerchantCoding(SyncMsgData syncMsgData);
}