package cn.com.duiba.activity.center.api.enums;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 集卡熟悉枚举
 * Created by gey on 2017/12/08.
 */
public enum CLRewardRuleTypeEnum {

    PLUS_MULTIPLE("plus_multiple","增加倍数"),
    REDUCE_MULTIPLE("reduce_multiple","减少倍数"),
    PLUS_SCORE("plus_score","增加分数"),
    REDUCE_SCORE("reduce_score","减少分数"),
    REVIVE_CARD("revive_card","复活卡");

    /**
     * key
     */
    private String key;
    /**
     * 描述
     */
    private String name;

    private static Map<String, CLRewardRuleTypeEnum> valueMap = new HashMap<>();
    static{
        for(CLRewardRuleTypeEnum typeEnum : values()){
            valueMap.put(typeEnum.getKey(), typeEnum);
        }
    }


    CLRewardRuleTypeEnum(String key ,String name){
        this.key = key;
        this.name = name;
    }

    /**
     * 通过key查询对应的em
     * @param key
     * @return
     */
    public static CLRewardRuleTypeEnum getCLRewardRuleTypeEnumByKey(String key){
        return valueMap.get(key);
    }


    public String getName() {
        return name;
    }

    public String getKey() {
        return key;
    }


    /**
     * 获取全部 枚举值和名称
     * @return
     */
    public static List<CLRewardRuleTypeEnum> getAll(){
        return valueMap.values().stream().collect(Collectors.toList());
    }
}
