package cn.com.duiba.activity.center.api.remoteservice.underseagame;

import cn.com.duiba.activity.center.api.dto.underseagame.UnderseaGamePrizeRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 海底游戏机抽奖记录-远程服务接口
 * @Author: xuwei
 * @Date: 2020/07/16
 */
@AdvancedFeignClient
public interface RemoteUnderseaGamePrizeRecordService {

    UnderseaGamePrizeRecordDto find(Long id);

    List<UnderseaGamePrizeRecordDto> findByIds(List<Long> ids);

    UnderseaGamePrizeRecordDto findByUnique(Long startId, Integer roundIndex, Long consumerId);

    Long insert(UnderseaGamePrizeRecordDto record);

    void updateOrderId(Long id, Long orderId);

    void updateStatus(Long id, int status);

    void updatePrizeValue(Long id, String prizeValue);
}