package cn.com.duiba.activity.center.api.dto.scraperedpacket;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信刮红包工具配置
 */
public class ScrapeRedPacketDto implements Serializable {

    private static final long serialVersionUID = 8904588673771155267L;
    // app投放渠道 投放链接里面会传输
    public static final int CHANNEL_APP = 1;
    // 公众号投放渠道 投放链接里面会传输
    public static final int CHANNEL_OFFICIAL_ACCOUNT = 2;
    // 小程序投放渠道 投放链接里面会传输
    public static final int CHANNEL_MINI_PROGRAM = 3;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 活动规则
     */
    private String rule;

    /**
     * 公众号渠道配置
     */
    private OfficialAccountConfig officialAccountConfig;

    /**
     * 小程序渠道配置
     */
    private MiniProgramConfig miniProgramConfig;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动结束时间
     */
    private Date endTime;

    /**
     * banner图
     */
    private String bannerImage;

    /**
     * 缩略图
     */
    private String smallImage;

    /**
     * 是否开启轮播 1:开启 0:关闭
     */
    private Integer openWheel;

    /**
     * 单个红包金额区间左
     */
    private Long bonusLeft;

    /**
     * 单个红包金额区间右
     */
    private Long bonusRight;

    /**
     * 获得红包需邀请好友数
     */
    private Integer targetNumber;

    /**
     * 红包数量
     */
    private Integer bonusNumber;

    /**
     * 翻倍卡最高倍率
     */
    private String highestRate;

    /**
     * 用户每次固定提现金额
     */
    private Long bonusLimit;

    /**
     * 总预算
     */
    private Long totalBudget;

    /**
     * 预算提醒
     */
    private Long warnBudget;

    /**
     * 预算短信通知手机号
     */
    private String phoneNumber;

    /**
     * 入库活动id
     */
    private Long operatingActivityId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 自定义账户id
     */
    private Long customAccountId;

    /**
     * 界面配置
     */
    private String dataJson;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    // 活动是否开启直冲防刷
    private boolean openBrush;

    public boolean isOpenBrush() {
        return openBrush;
    }

    public void setOpenBrush(boolean openBrush) {
        this.openBrush = openBrush;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public OfficialAccountConfig getOfficialAccountConfig() {
        return officialAccountConfig;
    }

    public void setOfficialAccountConfig(OfficialAccountConfig officialAccountConfig) {
        this.officialAccountConfig = officialAccountConfig;
    }

    public MiniProgramConfig getMiniProgramConfig() {
        return miniProgramConfig;
    }

    public void setMiniProgramConfig(MiniProgramConfig miniProgramConfig) {
        this.miniProgramConfig = miniProgramConfig;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Integer getOpenWheel() {
        return openWheel;
    }

    public void setOpenWheel(Integer openWheel) {
        this.openWheel = openWheel;
    }

    public Long getBonusLeft() {
        return bonusLeft;
    }

    public void setBonusLeft(Long bonusLeft) {
        this.bonusLeft = bonusLeft;
    }

    public Long getBonusRight() {
        return bonusRight;
    }

    public void setBonusRight(Long bonusRight) {
        this.bonusRight = bonusRight;
    }

    public Integer getTargetNumber() {
        return targetNumber;
    }

    public void setTargetNumber(Integer targetNumber) {
        this.targetNumber = targetNumber;
    }

    public Integer getBonusNumber() {
        return bonusNumber;
    }

    public void setBonusNumber(Integer bonusNumber) {
        this.bonusNumber = bonusNumber;
    }

    public String getHighestRate() {
        return highestRate;
    }

    public void setHighestRate(String highestRate) {
        this.highestRate = highestRate;
    }

    public Long getBonusLimit() {
        return bonusLimit;
    }

    public void setBonusLimit(Long bonusLimit) {
        this.bonusLimit = bonusLimit;
    }

    public Long getTotalBudget() {
        return totalBudget;
    }

    public void setTotalBudget(Long totalBudget) {
        this.totalBudget = totalBudget;
    }

    public Long getWarnBudget() {
        return warnBudget;
    }

    public void setWarnBudget(Long warnBudget) {
        this.warnBudget = warnBudget;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getCustomAccountId() {
        return customAccountId;
    }

    public void setCustomAccountId(Long customAccountId) {
        this.customAccountId = customAccountId;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return "ScrapeRedPacketDto{" +
                "id=" + id +
                ", title='" + title + '\'' +
                ", rule='" + rule + '\'' +
                ", officialAccountConfig=" + officialAccountConfig +
                ", miniProgramConfig=" + miniProgramConfig +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", bannerImage='" + bannerImage + '\'' +
                ", smallImage='" + smallImage + '\'' +
                ", openWheel=" + openWheel +
                ", bonusLeft=" + bonusLeft +
                ", bonusRight=" + bonusRight +
                ", targetNumber=" + targetNumber +
                ", bonusNumber=" + bonusNumber +
                ", highestRate='" + highestRate + '\'' +
                ", bonusLimit=" + bonusLimit +
                ", totalBudget=" + totalBudget +
                ", warnBudget=" + warnBudget +
                ", phoneNumber='" + phoneNumber + '\'' +
                ", operatingActivityId=" + operatingActivityId +
                ", appId=" + appId +
                ", customAccountId=" + customAccountId +
                ", dataJson='" + dataJson + '\'' +
                ", deleted=" + deleted +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
