package cn.com.duiba.activity.center.api.enums;

/**
 * 删除状态枚举
 */
public enum DeletedEnum {

    UNDELETED(0, "未删除"),
    DELETED(1, "删除");

    private int    value;
    private String desc;

    DeletedEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * 
     * value:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public int value() {
        return this.value;
    }

    /**
     * 
     * desc:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public String desc() {
        return this.desc;
    }

    /**
     * 
     * fromValue:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param value
     * @return
     * @since JDK 1.6
     */
    public static DeletedEnum fromValue(int value) {
        for (DeletedEnum it : DeletedEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }
}
