package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionRecordDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaSimpleQuestionRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@AdvancedFeignClient
public interface RemoteDuibaQuestionRecordService {

    /**
     * 
     * findByBankIdAndLimit:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param qBankId
     * @param limit
     * @return
     * @since JDK 1.6
     */
    List<DuibaQuestionRecordDto> findByBankIdAndLimit(Long qBankId, Integer limit);

    /**
     * 
     * findCountByBankIdsStr:(这里用一句话描述这个方法的作用). <br/>
     * 根据题库id的字符串查询出总数
     * @param bankIds
     * @return
     * @since JDK 1.6
     */
    public Long findCountByBankIdsStr(List<String> bankIds);
    /**
     * 
     * findById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaQuestionRecordDto findById(Long id);
    /**
     * 
     * findTotalCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param questionBankId
     * @return
     * @since JDK 1.6
     */
    public Long findTotalCount(Long questionBankId);

    //from DuibaQuestionRecordServiceImpl in manager,以下这些方法因为名字冲突,所以加上了_manager后缀

    /**
     * 
     * insert_manager:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param questionRecordDO
     * @return
     * @throws BusinessException
     * @since JDK 1.6
     */
    @Deprecated
    public DuibaQuestionRecordDto insert_manager(DuibaQuestionRecordDto questionRecordDO) throws BusinessException;

    public DuibaQuestionRecordDto insertManagerApi(DuibaQuestionRecordDto questionRecordDO) throws BizException;

    /**
     * 
     * findByPage_manager:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param questionBankId
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public PaginationDto<DuibaQuestionRecordDto> findByPage_manager(Long questionBankId, Integer offset, Integer max);
    
    /**
     * 
     * delete_manager:(这里用一句话描述这个方法的作用). <br/>
     * 删除题库的一个题目
     * @param id
     * @throws BusinessException
     * @since JDK 1.6
     */
    @Deprecated
    public void delete_manager(Long id) throws BusinessException;

    public void deleteManagerApi(Long id) throws BizException;

    /**
     * 查询指定题库下最新的1000个题,属性只有id,name,rightAnswer,option1-option4
     * 百万游戏在用,不是一个redis,所以没加redis缓存
     *
     * @param qBankId
     * @return
     */
    List<DuibaSimpleQuestionRecordDto> findByBankIdAndLimit1000(Long qBankId);


}
