package cn.com.duiba.activity.center.api.remoteservice.singleAward;

import cn.com.duiba.activity.center.api.domain.dto.singleAward.SingleAwardRecordDto;
import java.util.List;

import cn.com.duiba.activity.center.api.params.singleAward.SingleAwardRecordPageParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.Map;


@AdvancedFeignClient
public interface RemoteSingleAwardRecordService {

	Integer save(SingleAwardRecordDto singleAwardRecordDto) throws BizException;

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(SingleAwardRecordDto singleAwardRecordDto) throws BizException;

    SingleAwardRecordDto getById(Long id) throws BizException;

    List<SingleAwardRecordDto> listByIds(List<Long> ids) throws BizException;

    SingleAwardRecordDto getByOrderNum(Long activityOrderNum) throws BizException;

    List<SingleAwardRecordDto> listByOrderNums(List<Long> activityOrderNums) throws BizException;

    /**
     * 查询用户已领取次数
     * @param actId
     * @param consumerId
     * @param dateType SingleAwardDateTypeEnum
     * @return
     */
    Integer countUserReceivePrize(Long actId, Long consumerId, String dateType);

    /**
     * 查询用户最近一次待领取/待支付记录，理论上只可能有一条
     * @param actId
     * @param consumerId
     * @return
     */
    SingleAwardRecordDto getRecentlyWaitPayOrReceiveRecord(Long actId, Long consumerId);

    /**
     * 修改活动订单扩展信息
     * @param activityOrderNum
     * @param key
     * @param value
     * @return
     */
    Integer updateExtraByOrderNo(Long activityOrderNum, String key, String value);

    /**
     * 支付记录分页
     * @param param
     * @return
     */
    PageResponse<SingleAwardRecordDto> findPayRecordByPage(SingleAwardRecordPageParam param);
}
