package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityConfigDto;
import cn.com.duiba.activity.center.api.request.equity.FindPageRequest;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @program: activity-all
 * @description: 权益配置
 * @author: Simba
 * @create: 2019-07-08 11:45
 **/
@AdvancedFeignClient
public interface RemoteEquityConfigService {

    Long save(EquityConfigDto dto);

    int deleteById(Long id);

    int updateById(EquityConfigDto dto);

    EquityConfigDto selectById(Long id);

    EquityConfigDto selectByName(Long appId, String name);

    List<EquityConfigDto> selectByLikeName(Long appId, String name);

    List<EquityConfigDto> listByIds(List<Long> ids);

    Page<EquityConfigDto> findPageByConditions(FindPageRequest request);

    List<EquityConfigDto> selectByEquityCodes(Long appId, List<String> equityCodes);

    List<EquityConfigDto> selectByEquityTypes(Long appId, Integer verificationType, List<Integer> types);

    Boolean beLongToStationCustom(Long appId)  throws BizException;

    List<EquityConfigDto> selectByClassificationAndIds(Long appId, List<Long> ids, String classification) throws BizException;

    List<EquityConfigDto> selectGeneralList(Long appId);

    /**
     * 查询特定类型过期权益
     * 暂定60天内过期权益
     * @param appId
     * @param verificationType
     * @param equityType
     * @return
     */
    List<EquityConfigDto> selectExpiredEquityByParam(Long appId, Integer verificationType, Integer equityType);

    /**
     * 根据appId + 商品ID 查询有效的活动
     * @param appId
     * @param appItemIds
     * @return
     */
    List<EquityConfigDto> selectByAppIdAndAppItemIds(Long appId, List<Long> appItemIds);
}

