package cn.com.duiba.activity.center.api.remoteservice.joingroup;

import cn.com.duiba.activity.center.api.dto.joingroup.JoinGroupConfigDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 拼团活动配置
 */
@AdvancedFeignClient
public interface RemoteJoinGroupAppService {

	/**
	 * 根据拼团活动配置id获取拼团活动配置详情
	 */
	JoinGroupConfigDto findById(Long id) throws BizException;

	/**
	 * 根据自定义活动id(列表)获取拼团活动详情
	 */
	JoinGroupConfigDto findByActListId(Long relateActListId);

	/**
	 * 根据自定义活动id(详情)获取拼团活动详情
	 */
	JoinGroupConfigDto findByActDetailId(Long relateActDetailId);
}
