package cn.com.duiba.activity.center.api.remoteservice.ngame_app;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 *ngame_orders表按app维度的分表
 */
@AdvancedFeignClient
public interface RemoteNgameOrdersAppService {

    /**
     * 
     * findByLimit:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param queryMap
     * @return
     * @since JDK 1.6
     */
	public List<NgameOrdersDto> findByLimit(Map<String, Object> queryMap);
	
	/**
	 * 
	 * totalCount:(这里用一句话描述这个方法的作用). <br/>
	 * @param queryMap
	 * @return
	 * @since JDK 1.6
	 */
	public Long totalCount(Map<String, Object> queryMap);
	
	/**
	 * 
	 * countFailByOperatingActivityIds:(这里用一句话描述这个方法的作用). <br/>
	 * @param ids
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids, Long appId);
}
