package cn.com.duiba.activity.center.api.remoteservice.superSurprise;

import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseConfigDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRankListOptionDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/3/23 2:26 下午
 * 【天降好礼】活动相关api
 */
@AdvancedFeignClient
public interface RemoteSuperSurpriseService {


    /**
     * 保存活动配置
     * @param superSurpriseConfigDto
     * @return
     */
    Long saveConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 根据id查找活动配置
     * @param id
     * @return
     */
    SuperSurpriseConfigDto getById(Long id);


    /**
     * 更新配置
     * @param superSurpriseConfigDto
     * @return
     */
    int updateConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 批量插入排行榜奖品
     * @param list
     */
    void batchInsertRankOption(List<SuperSurpriseRankListOptionDto> list);

    /**
     * 根据活动id删除排行榜奖品
     * @param activityId
     * @return
     */
    int deleteRankOptionByActivityId(Long activityId);
}