package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益状态枚举类
 **/
public enum EquityValidateEnum {

    VALIDA(0, "有效"),
    INVALID(1, "无效"),
    ;
    private Integer code;
    private String desc;

    EquityValidateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityValidateEnum ofValue(Integer code) {
        for (EquityValidateEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

