package cn.com.duiba.activity.center.api.remoteservice.richman;

import cn.com.duiba.activity.center.api.dto.richman.RichManPieceDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 寻宝大富翁 棋子信息服务
 * @author 歪大哥😁
 * @date 2020-08-17.
 */
@AdvancedFeignClient
public interface RemoteRichManPieceService {


    /**
     * 根据活动id和用户id查询棋子
     * 如果不存在棋子 则初始化
     * @param operatingActivityId
     * @param consumerId
     * @return  棋子信息
     */
    RichManPieceDto findOrInit(Long operatingActivityId, Long consumerId);

    /**
     * 增加用户积分消耗
     * @param id  棋子id
     * @param delta  增加的积分数  必须大于0
     * @return 失败返回-1
     */
    Integer increaseCreditsCost(Long id, Integer delta);

    /**
     * 将棋子放到新的location上
     * @param id  棋子id
     * @param newLocation  新的location
     * @return 新的location
     */
    Integer changeLocationById(Long id, Integer newLocation);

    /**
     * 将棋子放到新的location上
     * @param operatingActivityId
     * @param consumerId
     * @param newLocation
     * @return
     */
    Integer changeLocation(Long operatingActivityId, Long consumerId, Integer newLocation);

}
