package cn.com.duiba.activity.center.api.remoteservice.book;

import cn.com.duiba.activity.center.api.dto.book.DuibaAppBookInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @description:兑吧书籍信息服务
 * @author: zhengwei
 * @date: 2018-07-17 10:14
 */
@AdvancedFeignClient
public interface RemoteDuibaAppBookInfoService {
    /**
     * 查询书籍信息列表
     * @param appId
     * @param actId
     * @return
     */
    List<DuibaAppBookInfoDto> findBookInfos (Long appId, Long actId, Integer category);

    /**
     * 批量插入书籍
     * @param list
     * @return
     */
    Boolean saveBooks(List<DuibaAppBookInfoDto> list);

    /**
     * 批量更新书籍
     * @param list
     * @return
     */
    Boolean updateBooks(List<DuibaAppBookInfoDto> list);
}
