package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcHdtoolTaskPrizeRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2023/11/6 15:14
 * @description:
 */
@AdvancedFeignClient
public interface RemoteHsbcHdtoolTaskPrizeRecordService {

    /**
     * 根据活动ID查询中奖记录
     * @param operatingActivityId
     * @return
     */
    List<HsbcHdtoolTaskPrizeRecordDto> findByActId(Long operatingActivityId);

    /**
     * 根据活动ID和任务id查询中奖记录
     *
     * @param operatingActivityId
     * @param taskId
     * @return
     */
    List<HsbcHdtoolTaskPrizeRecordDto> findByActAndTaskId(Long operatingActivityId, Long taskId);

    /**
     * 插入
     *
     * @param hsbcHdtoolTaskPrizeRecordDto
     * @return 主键id
     */
    Long insert(HsbcHdtoolTaskPrizeRecordDto hsbcHdtoolTaskPrizeRecordDto);


    /**
     * 更新中奖状态
     * @param id
     * @param status
     * @return
     */
    int updatePrizeStatus(Long id, Integer status);

    /**
     * 更新中奖记录
     * @param hsbcHdtoolTaskPrizeRecordDto
     * @return
     */
    int updateById(HsbcHdtoolTaskPrizeRecordDto hsbcHdtoolTaskPrizeRecordDto);
}
