package cn.com.duiba.activity.center.api.remoteservice.superSurprise;

import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseConfigDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseJoinRecordDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseJoinRecordQuery;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRankListOptionDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/3/23 2:26 下午
 * 【天降好礼】活动相关api
 */
@AdvancedFeignClient
public interface RemoteSuperSurpriseService {


    /**
     * 保存活动配置
     * @param superSurpriseConfigDto
     * @return
     */
    Long saveConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 根据id查找活动配置
     * @param id
     * @return
     */
    SuperSurpriseConfigDto getById(Long id);


    /**
     * 更新配置
     * @param superSurpriseConfigDto
     * @return
     */
    int updateConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 批量插入排行榜奖品
     * @param list
     */
    void batchInsertRankOption(List<SuperSurpriseRankListOptionDto> list);

    /**
     * 根据活动id删除排行榜奖品
     * @param activityId
     * @return
     */
    int deleteRankOptionByActivityId(Long activityId);


    /**
     * 根据活动id查询排行榜奖品
     * @param opId
     * @return
     */
    List<SuperSurpriseRankListOptionDto> findByOperatingActivityId(Long opId);


    /**
     * 保存参与记录
     * @param superSurpriseJoinRecordDto
     * @return
     */
    Long saveJoinRecord(SuperSurpriseJoinRecordDto superSurpriseJoinRecordDto);

    /**
     * 查询用户参与次数
     * @param query
     * @return
     */
    Integer countUserJoinTimes(SuperSurpriseJoinRecordQuery query);


    /**
     * 更新积分消耗状态
     * @param id
     * @param consumeCreditsStatus
     * @return
     */
    int updateCreditsStatusById(Long id, Integer consumeCreditsStatus);


    /**
     * 更新中奖状态
     * @param id
     * @param exchangeStatus
     * @return
     */
    int updateExchangeStatusById(Long id, Integer exchangeStatus);

    /**
     * 获取参与记录
     * @param id
     * @return
     */
    SuperSurpriseJoinRecordDto getJoinRecordById(Long id);
}