package cn.com.duiba.activity.center.api.enums;

/**
 * @author: zhengjianhao
 * @date: 2019/2/26 11:42
 * @description: 拼拼乐活动参团记录状态
 */
public enum HappyGroupRecordStatusEnum {
    UNDER_WAY(0, "拼团进行中"),
    EXCHANGE_WAITING(1, "拼团成功，待领奖"),
	EXCHANGE_PROCESSING(2, "拼团成功，领奖中"),
    EXCHANGE_SUCCESS(3, "拼团成功，已领奖"),
	FAILURE(4, "拼团失败"),
	;

    Integer code;
    String desc;

    HappyGroupRecordStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

	public static HappyGroupRecordStatusEnum getByCode(Integer code) {
		if (code == null) {
			return null;
		}
		for (HappyGroupRecordStatusEnum statusEnum : values()) {
			if (code.equals(statusEnum.code)) {
				return statusEnum;
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}
}
