package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达营销活动商品远程服务接口
 * @author Claude
 */
@AdvancedFeignClient
public interface RemoteWandaGoodsActItemService {
    
    /**
     * 批量创建商品
     */
    Boolean batchCreateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量更新商品
     */
    Boolean batchUpdateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量删除商品
     */
    Boolean batchDeleteItems(List<Long> ids);

    /**
     * 分页查询商品列表
     */
    Page<WandaGoodsActItemDto> pageQuery(WandaGoodsActItemQueryDto queryDto);
} 