package cn.com.duiba.activity.center.api.dto;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/6/21.
 */
public class ActivityDto extends BaseActivityDto implements Serializable {
    private static final long serialVersionUID = 6835450132317375955L;

    private Long id;
    private Long appId;
    private String title;
    private Integer type;
    private Integer status;
    private String strCredits;
    private Integer consumeCredits; // 消耗的总积分数
    private Integer consumeMoney;// 消耗的总金钱数
    private Integer visitTimes; // 参与人数
    private Integer winTimes; // 中奖人数
    private Integer credits; // 消耗积分数
    private Integer failCount; // 领取失败数量， 数据库无此字段
    private Integer orderCount; // 活动订单数
    private Integer limitCount; // 每日最多几次
    private String rule;// 活动规则
    private String explainText; // 活动说明
    private String image; // 主图
    private String logo;
    private String smallImage;
    private String bannerImage;
    private Long activityId;
    private Integer activityOrderQuantity;
    private Boolean deleted = false; // 是否已经删除
    private Long parentActivityId;
    private Date gmtCreate;
    private Date gmtModified;
    private String subType;//活动工具模版
    private String subTypeNew;//名称
    /**
     * 扩展字段
     * 20230208 活动平台需求增加（数据看板字段无预留字段保存，故此开放该字段）
     */
    private String extendJson;
	private List<ActivityDto> child;

    private Long appBannerId;
    private String appBannerTitle;
    private Boolean appBannerDeleted;
    private String appBannerImage;
    private String appBannerImageJson;

    private Long appItemId;
    private Boolean appItemDeleted;
    private String appItemTitle;
    private String appItemSubTitle;
    private String appItemLogo;
    private String appItemSmallImage;
    private String appItemWhiteImage;
    private String appItemImageJson;

    private Long salePrice; //兑换项售价

    private Long expressPrice;//运费价格

    private LimitDateDto limitDate;

    private Boolean oldTurntable = false;

    private String theme;//摇一摇主题回填到编辑页面链接后面
    private String style;//摇一摇模版回填到编辑页面链接后面
    private Integer customCredits; // 消耗积分数
    private Integer switches;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动截止时间
     */
    private Date autoOffDate;

    public String getSubTypeNew() {
        return subTypeNew;
    }

    public void setSubTypeNew(String subTypeNew) {
        this.subTypeNew = subTypeNew;
    }
    
    public Integer getCustomCredits() {
        return customCredits;
    }

    public void setCustomCredits(Integer customCredits) {
        this.customCredits = customCredits;
    }

    public Long getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(Long salePrice) {
        this.salePrice = salePrice;
    }

    public Long getExpressPrice() {
        return expressPrice;
    }

    public void setExpressPrice(Long expressPrice) {
        this.expressPrice = expressPrice;
    }

    public Boolean getOldTurntable() {
        return oldTurntable;
    }

    public void setOldTurntable(Boolean oldTurntable) {
        this.oldTurntable = oldTurntable;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAppBannerId() {
        return appBannerId;
    }

    public void setAppBannerId(Long appBannerId) {
        this.appBannerId = appBannerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Integer getConsumeCredits() {
        return consumeCredits;
    }

    public void setConsumeCredits(Integer consumeCredits) {
        this.consumeCredits = consumeCredits;
    }

    public Integer getConsumeMoney() {
        return consumeMoney;
    }

    public void setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
    }

    public Integer getVisitTimes() {
        return visitTimes;
    }

    public void setVisitTimes(Integer visitTimes) {
        this.visitTimes = visitTimes;
    }

    public Integer getWinTimes() {
        return winTimes;
    }

    public void setWinTimes(Integer winTimes) {
        this.winTimes = winTimes;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getExplainText() {
        return explainText;
    }

    public void setExplainText(String explainText) {
        this.explainText = explainText;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getFailCount() {
        return failCount;
    }

    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityOrderQuantity() {
        return activityOrderQuantity;
    }

    public void setActivityOrderQuantity(Integer activityOrderQuantity) {
        this.activityOrderQuantity = activityOrderQuantity;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getAppBannerDeleted() {
        return appBannerDeleted;
    }

    public void setAppBannerDeleted(Boolean appBannerDeleted) {
        this.appBannerDeleted = appBannerDeleted;
    }

    public String getAppBannerImage() {
        return appBannerImage;
    }

    public void setAppBannerImage(String appBannerImage) {
        this.appBannerImage = appBannerImage;
    }

    public String getAppItemTitle() {
        return appItemTitle;
    }

    public void setAppItemTitle(String appItemTitle) {
        this.appItemTitle = appItemTitle;
    }

    public String getAppItemSubTitle() {
        return appItemSubTitle;
    }

    public void setAppItemSubTitle(String appItemSubTitle) {
        this.appItemSubTitle = appItemSubTitle;
    }

    public String getAppItemLogo() {
        return appItemLogo;
    }

    public void setAppItemLogo(String appItemLogo) {
        this.appItemLogo = appItemLogo;
    }

    public String getAppItemSmallImage() {
        return appItemSmallImage;
    }

    public void setAppItemSmallImage(String appItemSmallImage) {
        this.appItemSmallImage = appItemSmallImage;
    }

    public Boolean getAppItemDeleted() {
        return appItemDeleted;
    }

    public void setAppItemDeleted(Boolean appItemDeleted) {
        this.appItemDeleted = appItemDeleted;
    }

    public Integer getOrderCount() {
        return orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public Long getParentActivityId() {
        return parentActivityId;
    }

    public void setParentActivityId(Long parentActivityId) {
        this.parentActivityId = parentActivityId;
    }

    public List<ActivityDto> getChild() {
        return child;
    }

    public void setChild(List<ActivityDto> child) {
        this.child = child;
    }

    public String getAppBannerTitle() {
        return appBannerTitle;
    }

    public void setAppBannerTitle(String appBannerTitle) {
        this.appBannerTitle = appBannerTitle;
    }

    public String getStrCredits() {
        return strCredits;
    }

    public void setStrCredits(String strCredits) {
        this.strCredits = strCredits;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public LimitDateDto getLimitDate() {
        return limitDate;
    }

    public void setLimitDate(LimitDateDto limitDate) {
        this.limitDate = limitDate;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getAppItemWhiteImage() {
        return appItemWhiteImage;
    }

    public void setAppItemWhiteImage(String appItemWhiteImage) {
        this.appItemWhiteImage = appItemWhiteImage;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    /**
     * 
     * isOpSwitches:(这里用一句话描述这个方法的作用). <br/>
     * @param opType
     * @return
     * @since JDK 1.6
     */
    public boolean isOpSwitches(int opType){
    	if(switches==null){
    		return false;
    	}
        int v=1<<opType;
        int ret= switches & v;
        return ret!=0;
    }

    /**
     * 是否新活动工具
     * @return
     */
    public boolean isNewHdtool(){
        return isOpSwitches(OperatingActivityDto.SWITCHES_HDTOOLS_NEW);
    }

    public String getAppBannerImageJson() {
        return appBannerImageJson;
    }

    public void setAppBannerImageJson(String appBannerImageJson) {
        this.appBannerImageJson = appBannerImageJson;
    }

    public String getAppItemImageJson() {
        return appItemImageJson;
    }

    public void setAppItemImageJson(String appItemImageJson) {
        this.appItemImageJson = appItemImageJson;
    }

    public String getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(String extendJson) {
        this.extendJson = extendJson;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getAutoOffDate() {
        return autoOffDate;
    }

    public void setAutoOffDate(Date autoOffDate) {
        this.autoOffDate = autoOffDate;
    }
}
