package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemHoldDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemQueryDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemStockDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达营销活动商品远程服务接口
 * @author Claude
 */
@AdvancedFeignClient
public interface RemoteWandaGoodsActItemService {
    
    /**
     * 批量创建商品
     */
    Boolean batchCreateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量更新商品
     */
    Boolean batchUpdateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量删除商品
     */
    Boolean batchDeleteItems(List<Long> ids);

    /**
     * 分页查询商品列表
     */
    Page<WandaGoodsActItemDto> pageQuery(WandaGoodsActItemQueryDto queryDto);

    /**
     * 根据ID批量查询商品
     * @param ids 商品ID列表
     * @return 商品信息列表
     */
    List<WandaGoodsActItemDto> batchQueryByIds(List<Long> ids);

    /**
     * 根据ID查询商品
     * @param id 商品ID
     * @return 商品信息
     */
    WandaGoodsActItemDto queryById(Long id);

    /**
     * 根据活动ID查询商品列表
     * @param actId 活动ID
     * @return 商品信息列表
     */
    List<WandaGoodsActItemDto> queryByActId(Long actId);

    /**
     * 根据商品ID扣减库存
     * @param id 商品ID
     * @param quantity 扣减数量
     * @return 扣减是否成功
     */
    Boolean deductStock(Long id, Integer quantity);

    /**
     * 后台管理-增加商品库存
     * @param id 商品ID
     * @param quantity 增加数量
     * @return 是否成功
     */
    Boolean adminIncreaseStock(Long id, Integer quantity);

    /**
     * 后台管理-减少商品库存
     * @param id 商品ID
     * @param quantity 减少数量
     * @return 是否成功
     */
    Boolean adminDecreaseStock(Long id, Integer quantity);

    /**
     * 后台管理-批量增加商品库存
     * @param stockDtos 商品库存信息列表
     * @return 是否成功
     */
    Boolean adminBatchIncreaseStock(List<WandaGoodsActItemStockDto> stockDtos);

    /**
     * 后台管理-批量减少商品库存
     * @param stockDtos 商品库存信息列表
     * @return 是否成功
     */
    Boolean adminBatchDecreaseStock(List<WandaGoodsActItemStockDto> stockDtos);

    /**
     * 增加商品库存
     * @param id 商品ID
     * @param stockNum 增加的库存数量
     * @return 是否增加成功
     */
    Boolean increaseStock(Long id, Integer stockNum);

    /**
     * 查询SKU的库存占用情况
     * @param appItemSkuIds SKU ID列表
     * @return 库存占用情况列表
     */
    List<WandaGoodsActItemHoldDto> querySkuStockHold(List<Long> appItemSkuIds,Long excludeActId);
} 