package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 万达营销活动远程服务接口
 * @author Claude
 */
@AdvancedFeignClient
public interface RemoteWandaGoodsActService {
    
    /**
     * 创建营销活动
     */
    Long createActivity(WandaGoodsActDto dto);

    /**
     * 更新营销活动
     */
    Boolean updateActivity(WandaGoodsActDto dto);

    /**
     * 删除营销活动
     */
    Boolean deleteActivity(Long id);

    /**
     * 查询营销活动
     */
    WandaGoodsActDto getActivity(Long id);

    /**
     * 关闭活动
     */
    Boolean closeActivity(Long id);

    /**
     * 分页查询活动列表
     */
    Page<WandaGoodsActDto> pageQuery(WandaGoodsQueryDto queryDto);
} 