package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaSubjectActDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaSubjectActQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 万达专题活动远程服务接口
 * @author Claude
 */
@AdvancedFeignClient
public interface RemoteWandaSubjectActService {

    /**
     * 插入专题活动
     */
    Long insertWandaSubjectAct(WandaSubjectActDto dto);

    /**
     * 更新专题活动
     */
    Integer updateWandaSubjectAct(WandaSubjectActDto dto);

    /**
     * 删除专题活动
     */
    Integer deleteWandaSubjectAct(Long id);

    /**
     * 查询专题活动
     */
    WandaSubjectActDto findWandaSubjectAct(Long id);

    /**
     * 关闭专题活动
     */
    Integer closeWandaSubjectAct(Long id);

    /**
     * 分页查询专题活动列表
     */
    Page<WandaSubjectActDto> pageListWandaSubjectAct(WandaSubjectActQueryDto wandaSubjectActQueryDto);

    /**
     * 计数专题活动
     */
    Integer countWandaSubjectAct(String actName, Integer status);

    /**
     * 增加商品销售数量。
     * @param id
     * @return
     */
    public int increaseSaleItemNum(Long id,Long quantity);
}