package cn.com.duiba.activity.center.api.params.activitychannel;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.annotation.JSONField;

/**
 * <p>app渠道配置参数</p>
 * <p>created by Xuwei on 2021/4/12<p>
 **/
public class AppChannelParam extends BaseActivityChannelParam {

    private static final long serialVersionUID = -1389692989892298790L;

    public static final int OFFICIAL_ACCOUNT = 0;
    public static final int MINI_PROGRAM = 1;

    /** APP分享到微信链接类型 0-公众号 1-小程序 */
    @JSONField(name = "sut")
    private Integer shareUrlType;

    public Integer getShareUrlType() {
        return shareUrlType;
    }

    public void setShareUrlType(Integer shareUrlType) {
        this.shareUrlType = shareUrlType;
    }

    @Override
    protected void checkSelected() throws BizException {
        super.checkSelected();
        if (shareUrlType == null) {
            throw new BizException("APP分享到微信链接类型不能为空");
        }
        if (shareUrlType != OFFICIAL_ACCOUNT && shareUrlType != MINI_PROGRAM) {
            throw new BizException("APP分享到微信链接类型不合法");
        }
    }

    @Override
    protected void checkUnselected() throws BizException {
        super.checkUnselected();
        if (shareUrlType != null && shareUrlType != OFFICIAL_ACCOUNT && shareUrlType != MINI_PROGRAM) {
            throw new BizException("APP分享到微信链接类型不合法");
        }
    }
}
