/**
 * Project Name:activity-center-api
 * File Name:RemoteCreditGameSkinTemplateService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.creditgame
 * Date:2016年9月13日下午4:23:09
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.creditgame;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameSkinTemplateDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteCreditGameSkinTemplateService <br/>
 * Date:     2016年9月13日 下午4:23:09 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteCreditGameSkinTemplateService {
    
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<CreditGameSkinTemplateDto> find(Long id);
    
    /**
     * 
     * findPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param pagingParameters
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<CreditGameSkinTemplateDto>> findPage(PagingParameters pagingParameters);
    
    /**
     * 
     * findByType:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param type
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<CreditGameSkinTemplateDto>> findByType(Byte type);
    
    /**
     * 
     * add:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> add(CreditGameSkinTemplateDto dto);
    
    /**
     * 
     * edit:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> edit(CreditGameSkinTemplateDto dto);
    
    /**
     * 
     * isTitleExist:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param name
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> isTitleExist(String name);
    
    /**
     * 
     * findCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> findCount();
}

