/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.tool;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryCalculatorUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryCalculatorUtil.class);

    public static LotteryCalculationResult calculateWinningList(String shenzhenIndexStr, String sme100IndexStr, Long winningQuota, Long totalCount) {
        BigDecimal shenzhenIndex = LotteryCalculatorUtil.parseIndexFromString(shenzhenIndexStr, new BigDecimal("0"));
        BigDecimal sme100Index = LotteryCalculatorUtil.parseIndexFromString(sme100IndexStr, new BigDecimal("0"));
        log.info("\u5f00\u59cb\u8ba1\u7b97\u4e2d\u7b7e\u540d\u5355\uff0c\u6df1\u8bc1\u6210\u6307: {}, \u4e2d\u5c0f100\u6307\u6570: {}, \u4e2d\u7b7e\u914d\u989d: {}, \u9884\u7ea6\u6b21\u6570: {}", new Object[]{shenzhenIndex, sme100Index, winningQuota, totalCount});
        if (shenzhenIndex == null || sme100Index == null || winningQuota == null || totalCount == null) {
            throw new IllegalArgumentException("\u8ba1\u7b97\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (winningQuota <= 0L || totalCount <= 0L) {
            throw new IllegalArgumentException("\u4e2d\u7b7e\u914d\u989d\u548c\u9884\u7ea6\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        LotteryCalculationResult result = new LotteryCalculationResult();
        result.setTotalCount(totalCount);
        result.setWinningQuota(winningQuota);
        try {
            Long baseNumber = LotteryCalculatorUtil.calculateBaseNumber(shenzhenIndex, sme100Index);
            result.setBaseNumber(baseNumber);
            log.info("\u8ba1\u7b97\u57fa\u6570A: {}", (Object)baseNumber);
            Long flipNumber = LotteryCalculatorUtil.calculateFlipNumber(baseNumber);
            result.setFlipNumber(flipNumber);
            log.info("\u8ba1\u7b97\u7ffb\u8f6c\u6570B: {}", (Object)flipNumber);
            Long startWinningNumber = LotteryCalculatorUtil.calculateStartWinningNumber(flipNumber, totalCount);
            result.setStartWinningNumber(startWinningNumber);
            log.info("\u8ba1\u7b97\u8d77\u59cb\u4e2d\u7b7e\u53f7Y: {}", (Object)startWinningNumber);
            Long orderLevel = LotteryCalculatorUtil.calculateOrderLevel(totalCount, winningQuota);
            result.setOrderLevel(orderLevel);
            log.info("\u8ba1\u7b97\u9636\u6570Z: {}", (Object)orderLevel);
            if (winningQuota > totalCount) {
                ArrayList<Long> winningNumbers = new ArrayList<Long>();
                for (long i = 1L; i <= totalCount; ++i) {
                    winningNumbers.add(i);
                }
                result.setWinningNumbers(winningNumbers);
                return result;
            }
            List<Long> winningNumbers = LotteryCalculatorUtil.calculateAllWinningNumbers(startWinningNumber, orderLevel, winningQuota, totalCount);
            result.setWinningNumbers(winningNumbers);
            log.info("\u8ba1\u7b97\u4e2d\u7b7e\u53f7\u7801\u5b8c\u6210\uff0c\u5171{}\u4e2a\u4e2d\u7b7e\u53f7: {}", (Object)winningNumbers.size(), winningNumbers);
            return result;
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u4e2d\u7b7e\u540d\u5355\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u8ba1\u7b97\u4e2d\u7b7e\u540d\u5355\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private static Long calculateBaseNumber(BigDecimal shenzhenIndex, BigDecimal sme100Index) {
        BigDecimal shenzhenPart = shenzhenIndex.multiply(BigDecimal.valueOf(100L));
        BigDecimal sme100Part = sme100Index.multiply(BigDecimal.valueOf(100L));
        BigDecimal sum = shenzhenPart.multiply(sme100Part);
        BigDecimal result = sum.multiply(BigDecimal.valueOf(10000L));
        return result.setScale(0, RoundingMode.DOWN).longValue();
    }

    private static Long calculateFlipNumber(Long baseNumber) {
        String baseStr = baseNumber.toString();
        StringBuilder reversed = new StringBuilder(baseStr).reverse();
        while (reversed.length() > 1 && reversed.charAt(0) == '0') {
            reversed.deleteCharAt(0);
        }
        return Long.valueOf(reversed.toString());
    }

    private static Long calculateStartWinningNumber(Long flipNumber, Long totalCount) {
        long remainder = flipNumber % totalCount;
        return remainder + 1L;
    }

    private static Long calculateOrderLevel(Long totalCount, Long winningQuota) {
        return totalCount / winningQuota;
    }

    private static List<Long> calculateAllWinningNumbers(Long startWinningNumber, Long orderLevel, Long winningQuota, Long totalCount) {
        ArrayList<Long> winningNumbers = new ArrayList<Long>();
        int n = 1;
        while ((long)n <= winningQuota) {
            long winningNumber;
            for (winningNumber = startWinningNumber + orderLevel * (long)(n - 1); winningNumber > totalCount; winningNumber -= totalCount.longValue()) {
            }
            winningNumbers.add(winningNumber);
            ++n;
        }
        return winningNumbers;
    }

    private static BigDecimal parseIndexFromString(String indexStr, BigDecimal defaultValue) {
        try {
            if (indexStr != null && !indexStr.trim().isEmpty()) {
                return new BigDecimal(indexStr.trim());
            }
        }
        catch (NumberFormatException e) {
            log.warn("\u89e3\u6790\u6307\u6570\u5b57\u7b26\u4e32\u5931\u8d25: {}, \u4f7f\u7528\u9ed8\u8ba4\u503c: {}", (Object)indexStr, (Object)defaultValue);
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        int i;
        String shenzhenIndex = "12571.37";
        String sme100Index = "7718.66";
        Long winningQuota = 1L;
        Long totalCount = 2L;
        LotteryCalculationResult result = LotteryCalculatorUtil.calculateWinningList(shenzhenIndex, sme100Index, winningQuota, totalCount);
        System.out.println("=== \u4e2d\u7b7e\u8ba1\u7b97\u7ed3\u679c ===");
        System.out.println("\u6df1\u8bc1\u6210\u6307\u6307\u6570: " + shenzhenIndex);
        System.out.println("\u4e2d\u5c0f100\u6307\u6570: " + sme100Index);
        System.out.println("\u57fa\u6570A: " + result.getBaseNumber());
        System.out.println("\u7ffb\u8f6c\u6570B: " + result.getFlipNumber());
        System.out.println("\u9884\u7ea6\u6b21\u6570X: " + result.getTotalCount());
        System.out.println("\u8d77\u59cb\u4e2d\u7b7e\u53f7Y: " + result.getStartWinningNumber());
        System.out.println("\u4e2d\u7b7e\u914d\u989d: " + result.getWinningQuota());
        System.out.println("\u9636\u6570Z: " + result.getOrderLevel());
        System.out.println("\u4e2d\u7b7e\u53f7\u7801: " + result.getWinningNumbers());
        List<Long> winningNumbers = result.getWinningNumbers();
        System.out.println("\n=== \u9a8c\u8bc1\u4e2d\u7b7e\u53f7\u7801 ===");
        for (i = 0; i < Math.min(5, winningNumbers.size()); ++i) {
            System.out.println("\u4e2d\u7b7e\u53f7" + (i + 1) + " = " + winningNumbers.get(i));
        }
        if (winningNumbers.size() > 5) {
            System.out.println("...");
            for (i = Math.max(winningNumbers.size() - 3, 5); i < winningNumbers.size(); ++i) {
                System.out.println("\u4e2d\u7b7e\u53f7" + (i + 1) + " = " + winningNumbers.get(i));
            }
        }
    }

    public static class LotteryCalculationResult {
        private Long baseNumber;
        private Long flipNumber;
        private Long startWinningNumber;
        private Long orderLevel;
        private List<Long> winningNumbers;
        private Long totalCount;
        private Long winningQuota;

        public Long getBaseNumber() {
            return this.baseNumber;
        }

        public Long getFlipNumber() {
            return this.flipNumber;
        }

        public Long getStartWinningNumber() {
            return this.startWinningNumber;
        }

        public Long getOrderLevel() {
            return this.orderLevel;
        }

        public List<Long> getWinningNumbers() {
            return this.winningNumbers;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Long getWinningQuota() {
            return this.winningQuota;
        }

        public void setBaseNumber(Long baseNumber) {
            this.baseNumber = baseNumber;
        }

        public void setFlipNumber(Long flipNumber) {
            this.flipNumber = flipNumber;
        }

        public void setStartWinningNumber(Long startWinningNumber) {
            this.startWinningNumber = startWinningNumber;
        }

        public void setOrderLevel(Long orderLevel) {
            this.orderLevel = orderLevel;
        }

        public void setWinningNumbers(List<Long> winningNumbers) {
            this.winningNumbers = winningNumbers;
        }

        public void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public void setWinningQuota(Long winningQuota) {
            this.winningQuota = winningQuota;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LotteryCalculationResult)) {
                return false;
            }
            LotteryCalculationResult other = (LotteryCalculationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$baseNumber = this.getBaseNumber();
            Long other$baseNumber = other.getBaseNumber();
            if (this$baseNumber == null ? other$baseNumber != null : !((Object)this$baseNumber).equals(other$baseNumber)) {
                return false;
            }
            Long this$flipNumber = this.getFlipNumber();
            Long other$flipNumber = other.getFlipNumber();
            if (this$flipNumber == null ? other$flipNumber != null : !((Object)this$flipNumber).equals(other$flipNumber)) {
                return false;
            }
            Long this$startWinningNumber = this.getStartWinningNumber();
            Long other$startWinningNumber = other.getStartWinningNumber();
            if (this$startWinningNumber == null ? other$startWinningNumber != null : !((Object)this$startWinningNumber).equals(other$startWinningNumber)) {
                return false;
            }
            Long this$orderLevel = this.getOrderLevel();
            Long other$orderLevel = other.getOrderLevel();
            if (this$orderLevel == null ? other$orderLevel != null : !((Object)this$orderLevel).equals(other$orderLevel)) {
                return false;
            }
            List<Long> this$winningNumbers = this.getWinningNumbers();
            List<Long> other$winningNumbers = other.getWinningNumbers();
            if (this$winningNumbers == null ? other$winningNumbers != null : !((Object)this$winningNumbers).equals(other$winningNumbers)) {
                return false;
            }
            Long this$totalCount = this.getTotalCount();
            Long other$totalCount = other.getTotalCount();
            if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
                return false;
            }
            Long this$winningQuota = this.getWinningQuota();
            Long other$winningQuota = other.getWinningQuota();
            return !(this$winningQuota == null ? other$winningQuota != null : !((Object)this$winningQuota).equals(other$winningQuota));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LotteryCalculationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $baseNumber = this.getBaseNumber();
            result = result * 59 + ($baseNumber == null ? 43 : ((Object)$baseNumber).hashCode());
            Long $flipNumber = this.getFlipNumber();
            result = result * 59 + ($flipNumber == null ? 43 : ((Object)$flipNumber).hashCode());
            Long $startWinningNumber = this.getStartWinningNumber();
            result = result * 59 + ($startWinningNumber == null ? 43 : ((Object)$startWinningNumber).hashCode());
            Long $orderLevel = this.getOrderLevel();
            result = result * 59 + ($orderLevel == null ? 43 : ((Object)$orderLevel).hashCode());
            List<Long> $winningNumbers = this.getWinningNumbers();
            result = result * 59 + ($winningNumbers == null ? 43 : ((Object)$winningNumbers).hashCode());
            Long $totalCount = this.getTotalCount();
            result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
            Long $winningQuota = this.getWinningQuota();
            result = result * 59 + ($winningQuota == null ? 43 : ((Object)$winningQuota).hashCode());
            return result;
        }

        public String toString() {
            return "LotteryCalculatorUtil.LotteryCalculationResult(baseNumber=" + this.getBaseNumber() + ", flipNumber=" + this.getFlipNumber() + ", startWinningNumber=" + this.getStartWinningNumber() + ", orderLevel=" + this.getOrderLevel() + ", winningNumbers=" + this.getWinningNumbers() + ", totalCount=" + this.getTotalCount() + ", winningQuota=" + this.getWinningQuota() + ")";
        }
    }
}

