package cn.com.duiba.activity.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 抽签工具分页查询参数
 * @author cgq
 * @date 2025-07-17
 */
public class LotteryToolPageQueryParam implements Serializable {
    /** 
     * 当前页码，从1开始
     * 默认查询第一页
     */
    @NotNull(message = "页码不能为空")
    @Min(value = 1, message = "页码必须大于等于1")
    private Integer pageNo;

    /** 
     * 每页大小，建议10-100
     * 默认查询10条
     */
    @NotNull(message = "每页大小不能为空")
    @Min(value = 1, message = "每页大小必须大于等于1")
    private Integer pageSize;

    /** 
     * 商品ID
     * 默认查询所有商品
     */
    private Long appItemId;

    /**
     * 商品id集合
     */
    private List<Long> appItemIdList;

    /** 
     * 抽奖状态：0 等待抽奖，1 抽奖中 2 抽奖成功 3抽奖失败 4待发码 5发码中
     * 默认查询所有状态
     */
    private Integer prizeDrawStatus;

    /** 
     * 抽奖状态列表
     * 默认查询所有状态
     */
    private List<Integer> prizeDrawStatusList;
    
    /** 
     * 创建人ID
     * 默认查询所有创建人
     */
    private Long createOperatorId;
    
    /** 
     * 创建人姓名
     * 默认查询所有创建人
     */
    private String createOperatorName;
    
    /** 
     * 创建时间开始
     * 默认查询所有时间
     */
    private Date gmtCreateStart;
    
    /** 
     * 创建时间结束
     * 默认查询所有时间
     */
    private Date gmtCreateEnd;
    
    /** 
     * 扫描时间开始
     * 默认查询所有时间
     */
    private Date scanTimeStart;
    
    /** 
     * 扫描时间结束
     * 默认查询所有时间
     */
    private Date scanTimeEnd;
    
    /** 
     * 分页偏移量，自动计算
     * 默认查询所有偏移量
     */
    private Integer offset;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
        // 自动计算 offset
        if (pageNo != null && pageSize != null) {
            this.offset = (pageNo - 1) * pageSize;
        }
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        // 自动计算 offset
        if (pageNo != null && pageSize != null) {
            this.offset = (pageNo - 1) * pageSize;
        }
    }
    
    public Integer getOffset() {
        if (offset == null && pageNo != null && pageSize != null) {
            this.offset = (pageNo - 1) * pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public List<Long> getAppItemIdList() {
        return appItemIdList;
    }

    public void setAppItemIdList(List<Long> appItemIdList) {
        this.appItemIdList = appItemIdList;
    }

    public Integer getPrizeDrawStatus() {
        return prizeDrawStatus;
    }

    public void setPrizeDrawStatus(Integer prizeDrawStatus) {
        this.prizeDrawStatus = prizeDrawStatus;
    }

    public List<Integer> getPrizeDrawStatusList() {
        return prizeDrawStatusList;
    }

    public void setPrizeDrawStatusList(List<Integer> prizeDrawStatusList) {
        this.prizeDrawStatusList = prizeDrawStatusList;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public Date getGmtCreateStart() {
        return gmtCreateStart;
    }

    public void setGmtCreateStart(Date gmtCreateStart) {
        this.gmtCreateStart = gmtCreateStart;
    }

    public Date getGmtCreateEnd() {
        return gmtCreateEnd;
    }

    public void setGmtCreateEnd(Date gmtCreateEnd) {
        this.gmtCreateEnd = gmtCreateEnd;
    }

    public Date getScanTimeStart() {
        return scanTimeStart;
    }

    public void setScanTimeStart(Date scanTimeStart) {
        this.scanTimeStart = scanTimeStart;
    }

    public Date getScanTimeEnd() {
        return scanTimeEnd;
    }

    public void setScanTimeEnd(Date scanTimeEnd) {
        this.scanTimeEnd = scanTimeEnd;
    }
} 