package cn.com.duiba.activity.center.api.enums.iqiyi;

/**
 * @Author: lufeng
 * @Description:
 * 商品状态。0：正在夺宝中，1：等待开奖，2：夺宝未成功，3：待领取，4：领取失败，5：领取成功'
 * @Date: Created in 2019/11/18
 */
public enum HappyCodeStatusEnum {
    ING(0, "正在夺宝中"),
    OPEN_PRIZE_WAITING(1, "等待开奖"),
    NO_PRIZE(2, "未中奖"),
    GET_PRIZE_WAITING(3, "待领取"),
    GET_PRIZE_FAIL(4, "领取失败"),
    GET_PRIZE_SUC(5, "领取成功");

    private Integer code;
    private String desc;

    HappyCodeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HappyCodeStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (HappyCodeStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }


    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
