package cn.com.duiba.activity.center.api.dto.bargain;

import java.io.Serializable;
import java.util.Date;

/**
 * @author author
 */
public class BargainActivityInfoDto implements Serializable {

    private static final long serialVersionUID = 8254551901599697729L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 活动标题
     * isNullAble:0
     */
    private String title;

    /**
     * 活动规则
     * isNullAble:0
     */
    private String activityRule;

    /**
     * 用户发起砍价次数限制
     * isNullAble:1
     */
    private Integer lanuchBargainLimit;

    /**
     * 发起砍价次数限制周期 0-无限 1-次/每日
     *
     * @see cn.com.duiba.activity.center.api.enums.LimitScope
     * isNullAble:0,defaultVal:0
     */
    private Integer lanuchBargainLimitScope;

    /**
     * 活动状态 0-关闭 1-开启
     * isNullAble:0,defaultVal:0
     *
     * @see cn.com.duiba.activity.center.api.enums.BargainActivityStatusEnum
     */
    private Integer activityStatus;

    /**
     * 删除标志位(0-正常 1-删除)
     * isNullAble:0,defaultVal:0
     *
     * @see cn.com.duiba.activity.center.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getActivityRule() {
        return activityRule;
    }

    public void setActivityRule(String activityRule) {
        this.activityRule = activityRule;
    }

    public Integer getLanuchBargainLimit() {
        return lanuchBargainLimit;
    }

    public void setLanuchBargainLimit(Integer lanuchBargainLimit) {
        this.lanuchBargainLimit = lanuchBargainLimit;
    }

    public Integer getLanuchBargainLimitScope() {
        return lanuchBargainLimitScope;
    }

    public void setLanuchBargainLimitScope(Integer lanuchBargainLimitScope) {
        this.lanuchBargainLimitScope = lanuchBargainLimitScope;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
