package cn.com.duiba.activity.center.api.remoteservice.hsbc;


import cn.com.duiba.activity.center.api.dto.hsbc.HsbcPointTaskDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteHsbcPointTaskService {
    /**
     * 查出app下taskId的任务
     *
     * @param appId  主键
     * @param taskId 任务Id
     * @return 任务
     */
    HsbcPointTaskDto findByAppIdAndTaskId(Long appId, String taskId);

    /**
     * 批量保存汇丰任务
     *
     * @param appId         应用id
     * @param pointTaskList 汇丰任务
     * @return true: 添加成功
     */
    boolean batchSavePointTasks(Long appId, List<HsbcPointTaskDto> pointTaskList);

    /**
     * 查出app下所有任务
     *
     * @param appId 应用Id
     * @return 任务列表
     */
    List<HsbcPointTaskDto> findAllTaskByAppId(Long appId);
}
