package cn.com.duiba.activity.center.api.remoteservice.equity;


import cn.com.duiba.activity.center.api.dto.equity.StationConfigDto;
import cn.com.duiba.activity.center.api.dto.equity.StationConfigWithEmployeeListDto;
import cn.com.duiba.activity.center.api.dto.equity.StationEmployeeSyncDto;
import cn.com.duiba.activity.center.api.request.equity.StationConfigFindRequest;
import cn.com.duiba.activity.center.api.request.equity.StationConfigSaveRequest;
import cn.com.duiba.activity.center.api.request.equity.StationStockBatchRequest;
import cn.com.duiba.activity.center.api.request.equity.StationStockRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteStationConfigService {


    Long save(StationConfigDto StationConfigDto);

    Long saveWithEmployeeList(StationConfigWithEmployeeListDto stationConfigDto);

    Integer updateById(StationConfigDto StationConfigDto);

    Integer updateAllById(StationConfigWithEmployeeListDto stationConfigDto);

    StationConfigDto getById(Long id);

    StationConfigWithEmployeeListDto getWithEmployeeListById(Long id);

    List<StationConfigDto> listByIds(List<Long> ids);

    StationConfigDto getByAidAcodeAphoneInd(Long appId, String adminCode, String adminPhone, Integer invalid);

    List<StationConfigDto> getByPartOfFields(StationConfigSaveRequest stationConfigSaveRequest) throws BizException;

    List<StationConfigWithEmployeeListDto> getByPartOfAppId(StationConfigSaveRequest stationConfigSaveRequest) throws BizException;

    void initAddAppItem(StationStockRequest stationStockRequest) throws BizException;

    void initAddAppItemBatch(StationStockBatchRequest request) throws BizException;

    void addAppItem(StationStockRequest stationStockRequest) throws BizException;

    List<StationConfigDto> getByAppIdAndValida(Long appId, Integer invalid) throws BizException;

    List<StationConfigDto> findByCondition(StationConfigFindRequest stationConfigFindRequest) throws BizException;

    List<StationConfigWithEmployeeListDto> findWithEmployeeListByCondition(StationConfigFindRequest stationConfigFindRequest) throws BizException;

    Boolean syncData(StationEmployeeSyncDto stationEmployeeSyncDto);
}
