package cn.com.duiba.activity.center.api.dto.carousel;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品轮播记
 *
 * @Author: xuwei
 * @Date: 2019/08/13 10:32
 */
public class CarouselItemRecordDto implements Serializable {

    private static final long serialVersionUID = -7441474616423242992L;

    public static final int EXCHANGE_TYPE_NORMAL = 0; //普兑商品
    public static final int EXCHANGE_TYPE_SECKILL = 1; //秒杀商品
    public static final int EXCHANGE_TYPE_VIP = 2; //会员商品

    /**
     * ID
     */
    private Long id;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 商品ID
     */
    private Long appItemId;

    /**
     * 兑换类型 0：普兑 1：秒杀 2：会员
     */
    private Integer exchangeType;

    /**
     * 用户名称
     */
    private String consumerName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Integer getExchangeType() {
        return exchangeType;
    }

    public void setExchangeType(Integer exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getConsumerName() {
        return consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName == null ? null : consumerName.trim();
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}