/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.kafka;

import cn.com.duiba.activity.center.biz.utils.ResourcesLoader;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KafkaClient {
    private Producer<String, String> producer = null;
    @Resource
    private ResourcesLoader resourcesLoader;
    public static final String APP_KAFKA_BOOTSTRAP_SERVERS = "app.kafka.bootstrap.servers";
    @Value(value="${activity.kafka.bootstrap.servers}")
    private String bootstrapServers;

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public Producer<String, String> getProducer() {
        return this.producer;
    }

    public String sendMsg(String queueName, String body) throws Exception {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        this.producer.send(new ProducerRecord(queueName, (Object)id, (Object)body), new Callback(){

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
            }
        });
        return id;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)3);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)0);
        props.put("request.timeout.ms", (Object)30000);
        props.put("metadata.fetch.timeout.ms", (Object)10000);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(props);
    }
}

