/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteManualLotteryService;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.service.manual.ManualOrderLotteryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteManualLotteryServiceImpl
implements RemoteManualLotteryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteManualLotteryServiceImpl.class);
    @Resource
    private AppManualLotteryService appManualLotteryService;
    @Resource
    private ManualOrderLotteryService manualOrderLotteryService;

    public DubboResult<List<AppManualLotteryDto>> scanOverManualLottery() {
        try {
            List<AppManualLotteryDto> appManualLotteryDtos = this.appManualLotteryService.scanOverManualLottery();
            return DubboResult.successResult(appManualLotteryDtos);
        }
        catch (Exception e) {
            LOGGER.error("scanOverManualLottery error ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public void updateManualLottery(AppManualLotteryDto appManualLottery) {
        if (appManualLottery == null) {
            return;
        }
        try {
            this.appManualLotteryService.updateManualLottery(appManualLottery);
        }
        catch (Exception e) {
            LOGGER.error("data :" + appManualLottery.toString(), (Object)e.getMessage());
        }
    }

    public void insert(AppManualLotteryDto appManualLotteryDto) {
        if (appManualLotteryDto == null) {
            return;
        }
        try {
            this.appManualLotteryService.insert(appManualLotteryDto);
        }
        catch (Exception e) {
            LOGGER.error("data :" + appManualLotteryDto.toString(), (Object)e.getMessage());
        }
    }

    public void update(AppManualLotteryDto appManualLotteryDto) {
        if (appManualLotteryDto == null) {
            return;
        }
        try {
            this.appManualLotteryService.update(appManualLotteryDto);
        }
        catch (Exception e) {
            LOGGER.error("data :" + appManualLotteryDto.toString(), (Object)e.getMessage());
        }
    }

    public DubboResult<AppManualLotteryDto> find(Long id) {
        if (id == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            AppManualLotteryDto appManualLotteryDto = this.appManualLotteryService.find(id);
            return DubboResult.successResult((Object)appManualLotteryDto);
        }
        catch (Exception e) {
            LOGGER.error("find:" + id, (Object)e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            Integer integer = this.manualOrderLotteryService.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
            return DubboResult.successResult((Object)integer);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            Integer integer = this.manualOrderLotteryService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
            return DubboResult.successResult((Object)integer);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            Integer integer = this.manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
            return DubboResult.successResult((Object)integer);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            Integer integer = this.manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
            return DubboResult.successResult((Object)integer);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            List<ManualLotteryOrderDto> orderDTOs = this.manualOrderLotteryService.findAllOpenManualLotteryByCondition(paramMap);
            return DubboResult.successResult(orderDTOs);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            Long lotteryCount = this.manualOrderLotteryService.findAllOpenManualLotteryCount(paramMap);
            return DubboResult.successResult((Object)lotteryCount);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findWardList(Long operatingActivityId) {
        if (operatingActivityId == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            List<ManualLotteryOrderDto> wardList = this.manualOrderLotteryService.findWardList(operatingActivityId);
            return DubboResult.successResult(wardList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findNoWardList(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            List<ManualLotteryOrderDto> wardList = this.manualOrderLotteryService.findNoWardList(paramMap);
            return DubboResult.successResult(wardList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findNoWardListCount(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            Long noWardListCount = this.manualOrderLotteryService.findNoWardListCount(paramMap);
            return DubboResult.successResult((Object)noWardListCount);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findStartOpenListByIds(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            List<ManualLotteryOrderDto> dtoList = this.manualOrderLotteryService.findStartOpenListByIds(paramMap);
            return DubboResult.successResult(dtoList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateAward(Long id, Long activityId, Date date) {
        if (id == null || activityId == null) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            int count = this.manualOrderLotteryService.updateAward(id, activityId, date);
            return DubboResult.successResult((Object)count);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ManualLotteryOrderDto> randomFindManualLottery(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            ManualLotteryOrderDto manualLotteryOrderDto = this.manualOrderLotteryService.randomFindManualLottery(paramMap);
            return DubboResult.successResult((Object)manualLotteryOrderDto);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public void updateNoAwardList(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return;
        }
        try {
            this.manualOrderLotteryService.updateNoAwardList(paramMap);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findAllNoAwardList(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            List<ManualLotteryOrderDto> allNoAwardList = this.manualOrderLotteryService.findAllNoAwardList(paramMap);
            return DubboResult.successResult(allNoAwardList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ManualLotteryOrderDto>> findAllByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            List<ManualLotteryOrderDto> allNoAwardList = this.manualOrderLotteryService.findAllByIds(ids);
            return DubboResult.successResult(allNoAwardList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ManualLotteryOrderDto> findByOrderId(Long orderId) {
        if (orderId == null) {
            return DubboResult.failResult((String)"param is null");
        }
        try {
            ManualLotteryOrderDto orderDTO = this.manualOrderLotteryService.findByOrderId(orderId);
            return DubboResult.successResult((Object)orderDTO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ManualLotteryOrderDto> findByAppAndDeveloperBizId(Long appId, String bizId) {
        if (appId == null || StringUtils.isBlank((CharSequence)bizId)) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            ManualLotteryOrderDto orderDTO = this.manualOrderLotteryService.findByAppAndDeveloperBizId(appId, bizId);
            return DubboResult.successResult((Object)orderDTO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public void insert(ManualLotteryOrderDto manualLotteryOrderDto) {
        if (manualLotteryOrderDto == null) {
            return;
        }
        try {
            this.manualOrderLotteryService.insert(manualLotteryOrderDto);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void update(ManualLotteryOrderDto manualLotteryOrderDto) {
        if (manualLotteryOrderDto == null) {
            return;
        }
        try {
            this.manualOrderLotteryService.update(manualLotteryOrderDto);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public DubboResult<ManualLotteryOrderDto> findOrder(Long id) {
        if (id == null) {
            return DubboResult.failResult((String)"param is null ");
        }
        try {
            ManualLotteryOrderDto orderDTO = this.manualOrderLotteryService.find(id);
            return DubboResult.successResult((Object)orderDTO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

