package cn.com.duiba.activity.center.biz.bo;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolStockConsumeDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolStockConsumeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service
public class HdtoolStockConsumeBo {

	private static Logger log = LoggerFactory.getLogger(HdtoolStockConsumeBo.class);
	@Autowired
	private DuibaHdtoolService duibaHdtoolService;
	@Autowired
	private HdtoolStockConsumeService hdtoolStockConsumeService;
	@Autowired
	private OperatingActivityOptionsService operatingActivityOptionsService;
	
	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void consumeDuibaHdtoolOptionStock(Long optionId, Long appId,String bizId, String bizSource) throws Exception{
		//锁
		DuibaHdtoolOptionsDto option = duibaHdtoolService.findOptionByIdForupdate(optionId);
		if(null == option){
			throw new Exception("奖项不存在");
		}
		if(option.getRemaining() != null && option.getRemaining() <= 0){
			throw new Exception("奖项库存不足");
		}
		int ret = duibaHdtoolService.decrementOptionRemaining(option.getId());
		if (ret < 1) {
			throw new Exception("更新兑吧活动奖项剩余个数异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
		hdtoolStock.setRelationId(option.getId());
		hdtoolStock.setRelationType(HdtoolStockConsumeDto.TYPE_DUIBA);
		hdtoolStock.setAppId(appId);
		hdtoolStock.setAction(HdtoolStockConsumeDto.ACTION_PAY);
		hdtoolStock.setBizId(bizId);
		hdtoolStock.setBizSource(bizSource);
		hdtoolStock.setQuantity(1L);
		hdtoolStock.setGmtCreate(now);
		hdtoolStock.setGmtModified(now);

		hdtoolStockConsumeService.insert(hdtoolStock);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void paybackDuibaHdtoolOptionStock(String bizId, String bizSource) throws Exception{
		HdtoolStockConsumeDto consume = hdtoolStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
		
		if(null == consume){
			log.error("记录不存在");
			return;
		}
		//锁
		DuibaHdtoolOptionsDto option = duibaHdtoolService.findOptionByIdForupdate(consume.getRelationId());
		if(null == option){
			log.error("记录不存在");
			return;
		}
		int ret = duibaHdtoolService.incrementOptionRemaining(option.getId());
		if (ret < 1) {
			throw new Exception("更新兑吧活动奖项剩余个数异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
		hdtoolStock.setRelationId(consume.getRelationId());
		hdtoolStock.setRelationType(consume.getRelationType());
		hdtoolStock.setAppId(consume.getAppId());
		hdtoolStock.setAction(HdtoolStockConsumeDto.ACTION_BACK);
		hdtoolStock.setBizId(consume.getBizId());
		hdtoolStock.setBizSource(consume.getBizSource());
		hdtoolStock.setQuantity(consume.getQuantity());
		hdtoolStock.setGmtCreate(now);
		hdtoolStock.setGmtModified(now);

		hdtoolStockConsumeService.insert(hdtoolStock);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void consumeAppHdtoolOptionStock(Long optionId, Long appId,String bizId, String bizSource) throws Exception{
		//锁
		OperatingActivityOptionsDto option = operatingActivityOptionsService.findForupdate(optionId);
		if(null == option){
			throw new Exception("奖项不存在");
		}
		if(option.getRemaining() != null && option.getRemaining() <= 0){
			throw new Exception("奖项库存不足");
		}
		int ret = operatingActivityOptionsService.decrementOptionRemaining(optionId);
		if (ret < 1) {
			throw new Exception("更新开发者活动奖项剩余个数异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
		hdtoolStock.setRelationId(option.getId());
		hdtoolStock.setRelationType(HdtoolStockConsumeDto.TYPE_APP);
		hdtoolStock.setAppId(appId);
		hdtoolStock.setAction(HdtoolStockConsumeDto.ACTION_PAY);
		hdtoolStock.setBizId(bizId);
		hdtoolStock.setBizSource(bizSource);
		hdtoolStock.setQuantity(1L);
		hdtoolStock.setGmtCreate(now);
		hdtoolStock.setGmtModified(now);

		hdtoolStockConsumeService.insert(hdtoolStock);
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS)
	public void paybackAppHdtoolOptionStock(String bizId, String bizSource) throws Exception{
		HdtoolStockConsumeDto consume = hdtoolStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
		
		if(null == consume){
			log.error("记录不存在");
			return;
		}
		//锁
		OperatingActivityOptionsDto option = operatingActivityOptionsService.findForupdate(consume.getRelationId());
		if(null == option){
			throw new Exception("奖项不存在");
		}
		int ret = operatingActivityOptionsService.incrementOptionRemaining(option.getId());
		if (ret < 1) {
			throw new Exception("更新开发者活动奖项剩余个数异常");
		}
		Date now = new Date(System.currentTimeMillis()/1000*1000);

		HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
		hdtoolStock.setRelationId(consume.getRelationId());
		hdtoolStock.setRelationType(consume.getRelationType());
		hdtoolStock.setAppId(consume.getAppId());
		hdtoolStock.setAction(HdtoolStockConsumeDto.ACTION_BACK);
		hdtoolStock.setBizId(consume.getBizId());
		hdtoolStock.setBizSource(consume.getBizSource());
		hdtoolStock.setQuantity(1L);
		hdtoolStock.setGmtCreate(now);
		hdtoolStock.setGmtModified(now);

		hdtoolStockConsumeService.insert(hdtoolStock);
	}

}
