/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.category.impl
 * Date:2016年6月7日上午9:10:44
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.category.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;

/**
 * ClassName:ActivityCategoryDaoImpl <br/>
 * Date:     2016年6月7日 上午9:10:44 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("activityCategoryDao")
public class ActivityCategoryDaoImpl extends ActivityBaseDao implements ActivityCategoryDao{

    @Override
    public int insert(ActivityCategoryEntity instance) {
        return insert("insert", instance);
    }

    @Override
    public int updateCategoryContent(long id, String content) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("id", id);
        params.put("content", content);
        int ret=update("updateCategoryContent", params);
        return ret;
    }

    @Override
    public int updateCategoryEnable(long id) {
        return update("updateCategoryEnable", id);
    }

    @Override
    public int updateCategoryDisable(long id) {
        return update("updateCategoryDisable", id);
    }

    @Override
    public List<ActivityCategoryEntity> selectAll() {
        return selectList("selectAll");
    }
    
    @Override
    public ActivityCategoryEntity select(long id) {
        return selectOne("select",id);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

}

