package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolOptionsDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaHdtoolOptionsDaoImpl extends ActivityBaseDao implements DuibaHdtoolOptionsDao {
	@Override
	public List<DuibaHdtoolOptionsEntity> findByHdtoolId(Long hdtoolId) {
		return selectList("findByHdtoolId", hdtoolId);
	}

	@Override
	public int addRemainingById(Long id, Integer addRemaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("addRemaining", addRemaining);
		return update("addRemainingById", paramMap);
	}

	@Override
	public int subRemainingById(Long id, Integer subRemaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("subRemaining", subRemaining);
		return update("subRemainingById", paramMap);
	}

	@Override
	public int updateRemainingById(Long id, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("remaining", remaining);
		return update("updateRemainingById", paramMap);
	}

	@Override
	public Integer findRemaingForupdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findRemaingForupdate", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
