package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameOrdersDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class NgameOrdersDaoImpl extends ActivityBaseDao implements NgameOrdersDao {

	@Override
	public NgameOrdersEntity find(Long gameOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", gameOrderId);
		return selectOne("find", paramMap);
	}

	@Override
	public List<Long> findOverdueOrder() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -7);
		Date startTime = cal.getTime();
		paramMap.put("startPrizeOverdueDate", startTime);
		paramMap.put("endPrizeOverdueDate", new Date());
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWait);
		return selectList("findOverdueOrder", paramMap);
	}


	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
