package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import cn.com.duiba.dcommons.enums.ActivityOrderStatusEnums;
import cn.com.duiba.dcommons.enums.ExchangeStatusEnums;

@Repository("quizzOrdersStatusChangeDAO")
public class QuizzOrdersStatusChangeDaoImpl extends ActivityBaseDao implements QuizzOrdersStatusChangeDao {

    private static Logger  log = LoggerFactory.getLogger(QuizzOrdersStatusChangeDaoImpl.class);

    @Autowired
    private QuizzOrdersDao quizzOrdersDao;

    /**
     * 修改订单领奖状态为失败
     */
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer,
                                          String error4consumer) {
        try {
            // 加入异常捕获，防止在过度其间抛出异常，流程中断。
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusFail);
            paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
            paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
            paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
            int ret = update("updateExchangeStatusToFail", paramMap);

            return ret;
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }

    }

    /**
     * 修改订单领奖状态为过期失效
     */
    public int updateExchangeStatusToOverdue(long id, long consumerId, String error4admin, String error4developer,
                                             String error4consumer) {
        // QuizzOrdersEntity order = quizzOrdersDao.find(id);
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);

        paramMap.put("id", id);
        paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusOverdue);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));

        return update("updateExchangeStatusToOverdue", paramMap);

    }

    /**
     * 修改订单状态失败
     */
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer,
                                  String error4consumer) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            // paramMap.put("status", QuizzOrdersDO.StatusFail);／／todo
            paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
            paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
            paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
            int ret = update("updateStatusToFail", paramMap);

            return ret;
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }
    }

    /**
     * 处理领奖
     */
    public Integer doTakePrize(Long consumerId, Long id) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);

            return update("doTakePrize", paramMap);
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }
    }

    /**
     * 领奖创建订单失败，回滚领奖
     */
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);

            return update("rollbackTakePrize", paramMap);
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }
    }

    /**
     * 处理抽奖结果
     */
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId,
                                       String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("appItemId", appItemId);
            paramMap.put("itemId", itemId);
            paramMap.put("prizeId", prizeId);
            paramMap.put("prizeName", prizeName);
            paramMap.put("prizeType", prizeType);
            paramMap.put("prizeFacePrice", prizeFacePrice);
            paramMap.put("couponId", couponId);
            paramMap.put("status", ActivityOrderStatusEnums.StatusSuccess);
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusWait);

            return update("updateLotteryResult", paramMap);
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }
    }

    @Override
    public Integer updateLotteryLuckResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId,
                                           String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("appItemId", appItemId);
            paramMap.put("itemId", itemId);
            paramMap.put("prizeId", prizeId);
            paramMap.put("prizeName", prizeName);
            paramMap.put("prizeType", prizeType);
            paramMap.put("prizeFacePrice", prizeFacePrice);
            paramMap.put("couponId", couponId);
            // paramMap.put("status", QuizzOrdersDO.StatusSuccess);//todo
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusWait);

            return update("updateLotteryLuckResult", paramMap);
        } catch (Exception e) {
            log.error("", e);
            return 0;
        }
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ_CONSUMER;
    }
}
