package cn.com.duiba.activity.center.biz.dao.singlelottery.impl;

/**
 * Created by yansen on 16/6/17.
 */

import cn.com.duiba.activity.center.api.vo.ActivityExtraInfoVO;
import cn.com.duiba.activity.center.api.vo.AddActivityVO;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.singlelottery.DuibaSingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.DuibaSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryAppSpecifyEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * 兑吧单品抽奖业务DAO
 */
@Repository
public class DuibaSingleLotteryDaoImpl extends ActivityBaseDao implements DuibaSingleLotteryDao {

    //DuibaSingleLotterySimpleDAO

    /**
     * 查询一天内，需要定时下架的单品抽奖
     * @return
     */
    @Override
    public List<DuibaSingleLotteryEntity> findAutoOff(){
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();

        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return selectList("findAutoOff", paramMap);
    }

    /**
     * 根据ID查询
     */
    @Override
    public DuibaSingleLotteryEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    /**
     * 单品抽奖分页列表
     */
    @Override
    public List<DuibaSingleLotteryEntity> findSingleLotteryPage(Map<String, Object> queryMap) {
        return selectList("findSingleLotteryPage", queryMap);
    }

    /**
     * 单品抽奖分页条数
     */
    @Override
    public List<DuibaSingleLotteryEntity> findSingleLottery(Map<String, Object> queryMap) {
        return selectList("findSingleLottery", queryMap);
    }

    /**
     * 获取管理员端单品抽奖活动数目
     */
    @Override
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap) {
        return selectOne("findSingleLotteryPageCount",queryMap);
    }

    /**
     * 获取可用兑吧单品抽奖
     */
    @Override
    public List<AddActivityVO> findAllDuibaSingleLottery(Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        return selectList("findAllDuibaSingleLottery", paramMap);
    }

    /**
     * 根据id集合查询
     */
    @Override
    public List<DuibaSingleLotteryEntity> findAllByIds(@Param("ids") List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds", paramMap);
    }

    /**
     * 模糊查询统计
     */
    @Override
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap) {
        return selectOne("getCountDuibaSingleLottery", queryMap);
    }

    /**
     * 根据兑吧单品和APP查询定向关系
     */
    @Override
    public SingleLotteryAppSpecifyEntity findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        paramMap.put("appId", appId);
        return selectOne("findSpecifyByDuibaSingleLotteryAndApp", paramMap);
    }

    /**
     * 根据duibaSingleLotteryId查询List
     */
    @Override
    public List<SingleLotteryAppSpecifyEntity> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        return selectList("findAllSpecifyByDuibaSingleLottery", paramMap);
    }

    /**
     * 通过定向ID查询定向关系
     */
    @Override
    public SingleLotteryAppSpecifyEntity findSpecifyById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findSpecifyById", paramMap);
    }

    /**
     * 查询是否被兑吧单品使用
     * @param itemId
     * @return
     */
    @Override
    public List<Long> findHasUserdSingleIds(Long itemId){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("itemId", itemId);
        return selectList("findHasUserdSingleIds", paramMap);
    }

    /**
     * 加锁
     * @param id
     * @return
     */
    @Override
    public SingleLotteryAppSpecifyEntity findSpecifyForupdate(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findSpecifyForupdate", paramMap);
    }

    /**
     *
     * @param id
     * @return
     */
    @Override
    public ActivityExtraInfoVO findExtraInfoById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findExtraInfoById", paramMap);
    }


    //DuibaSingleLotteryTextChangeDAO


    @Override
    public int updateAutoOffDate(Long id){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("updateAutoOffDate", paramMap);
    }

    /**
     * 新增兑吧单品抽奖
     */
    @Override
    public void insert(DuibaSingleLotteryEntity duibaSingleLotteryDO) {
        insert("insert", duibaSingleLotteryDO);
    }

    /**
     * 根据ID修改
     */
    @Override
    public int update(DuibaSingleLotteryEntity duibaSingleLotteryDO) {
        return update("update", duibaSingleLotteryDO);
    }

    /**
     * 主奖品减数量
     */
    @Override
    public int reduceMainItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("reduceMainItemRemaining", paramMap);
    }

    /**
     * 主奖品添加数量
     */
    @Override
    public int addMainItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("addMainItemRemaining", paramMap);
    }

    /**
     * 小奖品减数量
     */
    @Override
    public int reduceInciteItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("reduceInciteItemRemaining", paramMap);
    }

    /**
     * 小奖品加数量
     */
    @Override
    public int addInciteItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("addInciteItemRemaining", paramMap);
    }

    /**
     * 后台编辑更新
     */
    @Override
    public int updateForAdminEdit(DuibaSingleLotteryEntity duibaSingleLotteryDO) {
        return update("updateForAdminEdit", duibaSingleLotteryDO);
    }

    /**
     * 减去定向APP数量
     */
    @Override
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        paramMap.put("appId", appId);
        return update("reduceSpecifyAppRemaining", paramMap);
    }

    /**
     * 添加定向APP数量
     */
    @Override
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        paramMap.put("appId", appId);
        return update("addSpecifyAppRemaining", paramMap);
    }

    /**
     * 加APP定向订单数
     */
    @Override
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("duibaSingleLotteryId", duibaSingleLotteryId);
        paramMap.put("appId", appId);
        return update("addSpecifyOrderCount", paramMap);
    }

    /**
     * 删除定向
     */
    @Override
    public int deleteSpecify(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return delete("deleteSpecify", paramMap);
    }

    /**
     * 添加APP定向关系
     */
    @Override
    public void insertAppSpecify(SingleLotteryAppSpecifyEntity singleLotteryAppSpecifyDO) {
        insert("insertAppSpecify", singleLotteryAppSpecifyDO);
    }

    /**
     * 修改定向数量
     */
    @Override
    public int updateSpecifyRemaining(Long id, Integer remaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("remaining", remaining);
        return update("updateSpecifyRemaining", paramMap);
    }


    //DuibaSingleLotteryStatusChangeDAOImpl


    @Override
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("addMainItemRemaining", addMainItemRemaining);
        return update("addMainItemRemainingById", paramMap);
    }

    @Override
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("subMainItemRemaining", subMainItemRemaining);
        return update("subMainItemRemainingById", paramMap);
    }

    @Override
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("addInciteItemRemaining", addInciteItemRemaining);
        return update("addInciteItemRemainingById", paramMap);
    }

    @Override
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("subInciteItemRemaining", subInciteItemRemaining);
        return update("subInciteItemRemainingById", paramMap);
    }

    @Override
    public DuibaSingleLotteryEntity findForupdate(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findForupdate", paramMap);
    }


    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
