package cn.com.duiba.activity.center.biz.remoteservice.impl.activity;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import com.alibaba.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/6/12.
 */
@Service
public class RemoteOperatingActivityOptionsServiceImpl implements RemoteOperatingActivityOptionsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteOperatingActivityOptionsServiceImpl.class);


    @Resource
    private OperatingActivityOptionsService operatingActivityOptionsService;

    @Override
    public OperatingActivityOptionsDto findOptionById(Long id) {
        return operatingActivityOptionsService.findOptionById(id);
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsService.findByOperatingActivityId(operatingActivityId);
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsService.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsService.decrementOptionRemaining(optionId);
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsService.incrementOptionRemaining(optionId);
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        return operatingActivityOptionsService.updateOptionDeleteStatus(oaoList);
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        return operatingActivityOptionsService.updatePrize(operatingActivityOptionsDO);
    }

    @Override
    public OperatingActivityOptionsDto insertOption(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        operatingActivityOptionsService.insertOption(operatingActivityOptionsDO);
        return operatingActivityOptionsDO;
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDO) {
        return operatingActivityOptionsService.updateOption(operatingActivityOptionsDO);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        return operatingActivityOptionsService.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        return operatingActivityOptionsService.subRemainingById(id, subRemaining);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return operatingActivityOptionsService.updateRemainingById(id, remaining);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        return operatingActivityOptionsService.findRemaingForupdate(id);
    }

    @Override
    public OperatingActivityOptionsDto findForupdate(Long id) {
        return operatingActivityOptionsService.findForupdate(id);
    }

}
