package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzServiceInner;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/6/13.
 */
@Service
public class RemoteDuibaQuizzServiceImpl implements RemoteDuibaQuizzServiceInner {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteDuibaQuizzServiceImpl.class);

    @Resource
    private DuibaQuizzService   duibaQuizzService;

    @Override
    public DubboResult<DuibaQuizzDto> find(Long id) {
        try {
            return DubboResult.successResult(duibaQuizzService.find(id));
        } catch (Exception e) {
            LOG.error("find by id " + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DuibaQuizzDto>> findByPage(Integer offset, Integer max) {
        try {
            return DubboResult.successResult(duibaQuizzService.findByPage(offset, max));
        } catch (Exception e) {
            LOG.error("findByPage offset " + offset, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findPageCount(Map<String, Object> paramMap) {
        try {
            return DubboResult.successResult(duibaQuizzService.findPageCount(paramMap));
        } catch (Exception e) {
            LOG.error("findPageCount ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DuibaQuizzDto>> findByPage(Map<String, Object> paramMap) {
        try {
            return DubboResult.successResult(duibaQuizzService.findByPage(paramMap));
        } catch (Exception e) {
            LOG.error("findByPage ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateStatus(Long id, int status) {
        try {
            return DubboResult.successResult(duibaQuizzService.updateStatus(id, status));
        } catch (Exception e) {
            LOG.error("updateStatus id  " + id + " status " + status, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> delete(Long id) {
        try {
            return DubboResult.successResult(duibaQuizzService.delete(id));
        } catch (Exception e) {
            LOG.error("delete id :" + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> insert(DuibaQuizzDto duibaQuizzDto) {
        try {
            return DubboResult.successResult(duibaQuizzService.insert(duibaQuizzDto));
        } catch (Exception e) {
            LOG.error("insert :" + duibaQuizzDto != null ? duibaQuizzDto.toString() : duibaQuizzDto.toString(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateInfoForm(DuibaQuizzDto duibaQuizzDto) {
        try {
            return DubboResult.successResult(duibaQuizzService.updateInfoForm(duibaQuizzDto));
        } catch (Exception e) {
            LOG.error("updateInfoForm :" + duibaQuizzDto != null ? duibaQuizzDto.toString() : "", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateAutoOffDateNull(Long id) {
        try {
            return DubboResult.successResult(duibaQuizzService.updateAutoOffDateNull(id));
        } catch (Exception e) {
            LOG.error("updateAutoOffDateNull :" + id, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateSwitches(Long id, Long switches) {
        try {
            return DubboResult.successResult(duibaQuizzService.updateSwitches(id, switches));
        } catch (Exception e) {
            LOG.error("updateSwitches :id" + id + " switches " + switches, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DuibaQuizzDto>> findAutoOff() {
        try {
            return DubboResult.successResult(duibaQuizzService.findAutoOff());
        } catch (Exception e) {
            LOG.error("findAutoOff ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DuibaQuizzDto>> findAllByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(duibaQuizzService.findAllByIds(ids));
        } catch (Exception e) {
            LOG.error("findAllByIds ids  ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<AddActivityDto>> findAllQuizz() {
        try {
            return DubboResult.successResult(duibaQuizzService.findAllQuizz());
        } catch (Exception e) {
            LOG.error("findAllByIds ids  ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> update(DuibaQuizzDto DuibaQuizzDto) {
        try {
            return DubboResult.successResult(duibaQuizzService.update(DuibaQuizzDto));
        } catch (Exception e) {
            LOG.error("update   ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
