package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityOptionsDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityOptionsEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import com.google.common.base.Preconditions;
import net.sf.cglib.beans.BeanCopier;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by yansen on 16/6/12.
 */
@Service
public class OperatingActivityOptionsServiceImpl implements OperatingActivityOptionsService {
    @Resource
    private OperatingActivityOptionsDao operatingActivityOptionsDao;

    private static final BeanCopier Entity2DTO = BeanCopier.create(OperatingActivityOptionsEntity.class,
            OperatingActivityOptionsDto.class, false);

    private static final BeanCopier DTO2Entity = BeanCopier.create(OperatingActivityOptionsDto.class,
            OperatingActivityOptionsEntity.class, false);

    @Override
    public OperatingActivityOptionsDto findOptionById(Long id) {
        OperatingActivityOptionsEntity entity = operatingActivityOptionsDao.findOptionById(id);
        return copyEntity(entity);
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId) {
        List<OperatingActivityOptionsEntity> entities=operatingActivityOptionsDao.findByOperatingActivityId(operatingActivityId);
        if(CollectionUtils.isEmpty(entities)){
            return Collections.emptyList();
        }
        List<OperatingActivityOptionsDto> dtoList=new ArrayList<>(entities.size());
        for(OperatingActivityOptionsEntity entity:entities){
            dtoList.add(copyEntity(entity));
        }
        return dtoList;
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsDao.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsDao.decrementOptionRemaining(optionId);
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        return operatingActivityOptionsDao.incrementOptionRemaining(optionId);
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        return operatingActivityOptionsDao.updateOptionDeleteStatus(oaoList);
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        return operatingActivityOptionsDao.updatePrize(copyDto(operatingActivityOptionsDto));
    }

    @Override
    public void insertOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(true);
        DTO2Entity.copy(operatingActivityOptionsDto,entity,null);
        operatingActivityOptionsDao.insertOption(entity);
        operatingActivityOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(operatingActivityOptionsDto.getId());
        DTO2Entity.copy(operatingActivityOptionsDto,entity,null);
        return operatingActivityOptionsDao.updateOption(entity);
    }

    @Override
    public OperatingActivityOptionsDto findForupdate(Long id) {
        OperatingActivityOptionsEntity entity= operatingActivityOptionsDao.findForupdate(id);
        return copyEntity(entity);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        return operatingActivityOptionsDao.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        return operatingActivityOptionsDao.subRemainingById(id, subRemaining);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return operatingActivityOptionsDao.updateRemainingById(id, remaining);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        return operatingActivityOptionsDao.findRemaingForupdate(id);
    }

    private OperatingActivityOptionsDto copyEntity(OperatingActivityOptionsEntity entity){
        if (entity == null) {
            return null;
        }
        OperatingActivityOptionsDto dto = new OperatingActivityOptionsDto();
        Entity2DTO.copy(entity, dto, null);
        return dto;
    }

    private OperatingActivityOptionsEntity copyDto(OperatingActivityOptionsDto dto){
        if(dto==null){
            return null;
        }
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity();
        DTO2Entity.copy(dto,entity,null);
        return entity;
    }
}
