package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameStockManualChangeDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameStockManualChangeEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameStockManualChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class DuibaNgameStockManualChangeServiceImpl implements DuibaNgameStockManualChangeService {
    @Resource
    private DuibaNgameStockManualChangeDao duibaNgameStockManualChangeDao;

    @Override
    public List<DuibaNgameStockManualChangeDto> findByStockId(Long gameStockId) {
        return BeanUtils.copyList(duibaNgameStockManualChangeDao.findByStockId(gameStockId), DuibaNgameStockManualChangeDto.class);
    }

    @Override
    public void addBatch(List<DuibaNgameStockManualChangeDto> list) {
        duibaNgameStockManualChangeDao.addBatch(BeanUtils.copyList(list, DuibaNgameStockManualChangeEntity.class));
    }

    @Override
    public void add(DuibaNgameStockManualChangeDto gameStockManualChangeDO) {
        duibaNgameStockManualChangeDao.add(BeanUtils.copy(gameStockManualChangeDO, DuibaNgameStockManualChangeEntity.class));
    }
}
