package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersExtraDto;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersExtraEntity;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersExtraService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class NgameOrdersExtraServiceImpl implements NgameOrdersExtraService {
    @Resource
    private NgameOrdersExtraDao ngameOrdersExtraDao;

    public void insert(NgameOrdersExtraDto gameOrdersExtraDO) {
        NgameOrdersExtraEntity e = BeanUtils.copy(gameOrdersExtraDO, NgameOrdersExtraEntity.class);
        ngameOrdersExtraDao.insert(e);
        gameOrdersExtraDO.setId(e.getId());
    }

    @Override
    public NgameOrdersExtraDto find(Long id) {
        return BeanUtils.copy(ngameOrdersExtraDao.find(id), NgameOrdersExtraDto.class);
    }

    @Override
    public NgameOrdersExtraDto findByGameOrderId(Long gameOrderId) {
        return BeanUtils.copy(ngameOrdersExtraDao.findByGameOrderId(gameOrderId), NgameOrdersExtraDto.class);
    }

    @Override
    public int updateOrderId(Long id, Long mainOrderId, String mainOrderNum) {
        return ngameOrdersExtraDao.updateOrderId(id, mainOrderId, mainOrderNum);
    }
}
