package cn.com.duiba.activity.center.biz.service.ngame_con.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersExtendDto;
import cn.com.duiba.activity.center.biz.dao.ngame_con.NgameOrdersConsumerDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.NgameMQSend;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersExtendService;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersService;
import cn.com.duiba.activity.center.biz.service.ngame_con.NgameOrdersConsumerService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class NgameOrdersConsumerServiceImpl implements NgameOrdersConsumerService {
    private static Logger log = LoggerFactory.getLogger(NgameOrdersConsumerServiceImpl.class);

    @Resource
    private NgameOrdersConsumerDao ngameOrdersConsumerDao;
    @Autowired
    private NgameOrdersService ngameOrdersService;
    @Autowired
    private NgameOrdersExtendService ngameOrdersExtendService;
    @Autowired
    private NgameMQSend ngameMQSend;

    @Override
    public NgameOrdersDto find(Long consumerId, Long gameOrderId) {
        return BeanUtils.copy(ngameOrdersConsumerDao.find(consumerId, gameOrderId), NgameOrdersDto.class);
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return ngameOrdersConsumerDao.findConsumerFreeNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return ngameOrdersConsumerDao.findConsumerFreeNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return ngameOrdersConsumerDao.findConsumerLimitNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return ngameOrdersConsumerDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public List<NgameOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return BeanUtils.copyList(ngameOrdersConsumerDao.findByIds(consumerId, ids), NgameOrdersDto.class);
    }

    @Override
    public void insert(NgameOrdersDto ngameOrdersDto) {
        NgameOrdersEntity e = BeanUtils.copy(ngameOrdersDto, NgameOrdersEntity.class);
        int ret = ngameOrdersConsumerDao.insert(e);
        ngameOrdersDto.setId(e.getId());

        NgameOrdersExtendDto noe = new NgameOrdersExtendDto(true);
        noe.setGameOrderId(ngameOrdersDto.getId());
        ngameOrdersExtendService.insert(noe);

        if(ret==1){
            ngameMQSend.ngameSendDataSync(ngameOrdersDto.getConsumerId(), ngameOrdersDto.getId());
        }
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        int ret = ngameOrdersConsumerDao.updateDeveloperBizId(consumerId, id, bizId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        int ret = ngameOrdersConsumerDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, id);
        }

        return ret;
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        int ret = ngameOrdersConsumerDao.updateStatusToConsumeSuccess(consumerId, gameOrderId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        int ret = ngameOrdersConsumerDao.updateStatusToSuccess(consumerId, gameOrderId, gameOrderExtraId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = ngameOrdersConsumerDao.updateStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long gameOrderId, String gameDataStr) {
        int ret = ngameOrdersConsumerDao.updateExchangeStatusToWaitOpen(consumerId, gameOrderId, gameDataStr);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long gameOrderId, String gameDataStr, Long gameOrderExtraId) {
        int ret = ngameOrdersConsumerDao.updateExchangeStatusToWaitOpenAndExtraId(consumerId, gameOrderId, gameDataStr, gameOrderExtraId);
        ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = ngameOrdersConsumerDao.updateExchangeStatusToWait(consumerId, gameOrderId, gameDataStr, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        NgameOrdersDto order= ngameOrdersService.find(gameOrderId);
        int ret = ngameOrdersConsumerDao.updateExchangeStatusToOverdue(gameOrderId, order.getConsumerId(), error4admin, error4developer, error4consumer);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(order.getConsumerId(), gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = ngameOrdersConsumerDao.updateExchangeStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        int ret = ngameOrdersConsumerDao.doTakePrize(consumerId, gameOrderId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        int ret = ngameOrdersConsumerDao.rollbackTakePrize(consumerId, gameOrderId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = ngameOrdersConsumerDao.updateManualOpenPrizeExchangeStatusToWait(consumerId, gameOrderId, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if(ret==1){
            ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }
}
