package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersService;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class QuizzOrdersServiceImpl implements QuizzOrdersService {

    @Resource
    private QuizzOrdersDao quizzOrdersDao;

    @Override
    public QuizzOrdersEntity find(Long id) {
        Preconditions.checkNotNull(id, "id is null");
        return quizzOrdersDao.find(id);
    }

    @Override
    public List<Long> findExpireOrder() {
        return quizzOrdersDao.findExpireOrder();
    }

    @Override
    public List<QuizzOrdersEntity> findAllByIds(List<Long> ids) {
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(ids));
        return quizzOrdersDao.findAllByIds(ids);
    }
}
