package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersSimpleService;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class QuizzOrdersSimpleServiceImpl implements QuizzOrdersSimpleService {

    @Resource
    private QuizzOrdersSimpleDao quizzOrdersSimpleDao;

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {

        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(operatingActivityId, "operatingActivityId is null");
        return quizzOrdersSimpleDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                  Date start, Date end) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(operatingActivityId, "operatingActivityId is null");
        Preconditions.checkNotNull(start, "start is null");
        Preconditions.checkNotNull(end, "end is null");
        return quizzOrdersSimpleDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId,
                                                                                   start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long id, Date start, Date end) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "operatingActivityId is null");
        Preconditions.checkNotNull(start, "start is null");
        Preconditions.checkNotNull(end, "end is null");
        return quizzOrdersSimpleDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, id, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long id) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "operatingActivityId is null");

        return quizzOrdersSimpleDao.countFreeByConsumerIdAndOperatingActivityId(consumerId, id);
    }

    @Override
    public QuizzOrdersEntity find(Long consumerId, Long id) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "operatingActivityId is null");

        return quizzOrdersSimpleDao.find(consumerId, id);
    }

    @Override
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(operatingActivityId, "operatingActivityId is null ");
        Preconditions.checkNotNull(prizeId, "prizeId is null ");

        return quizzOrdersSimpleDao.countByConsumerIdAndPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<QuizzOrdersEntity> findByIds(Long consumerId, List<Long> ids) {

        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(ids));

        return quizzOrdersSimpleDao.findByIds(consumerId, ids);
    }
}
